/*
 * Decompiled with CFR 0.152.
 */
package mage.target;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.constants.Zone;
import mage.game.Game;
import mage.target.TargetImpl;

public abstract class TargetObject
extends TargetImpl {
    protected TargetObject() {
    }

    public TargetObject(Zone zone) {
        this(1, 1, zone, false);
    }

    public TargetObject(int numTargets, Zone zone) {
        this(numTargets, numTargets, zone, false);
    }

    protected TargetObject(TargetObject target) {
        super(target);
    }

    public TargetObject(int minNumTargets, int maxNumTargets, Zone zone, boolean notTarget) {
        this.minNumberOfTargets = minNumTargets;
        this.maxNumberOfTargets = maxNumTargets;
        this.zone = zone;
        this.targetName = "card";
        this.notTarget = notTarget;
    }

    @Override
    public String getTargetedName(Game game) {
        StringBuilder sb = new StringBuilder();
        for (UUID targetId : this.getTargets()) {
            MageObject object = game.getObject(targetId);
            if (object == null) continue;
            sb.append(object.getLogName()).append(' ');
        }
        return sb.toString().trim();
    }

    @Override
    public boolean canTarget(UUID id, Ability source, Game game) {
        MageObject object = game.getObject(id);
        return object != null && this.zone != null && this.zone.match(game.getState().getZone(id)) && this.getFilter() != null && this.getFilter().match(object, game);
    }

    @Override
    public boolean canTarget(UUID playerId, UUID id, Ability source, Game game) {
        return this.canTarget(id, source, game);
    }
}

