/*
 * Decompiled with CFR 0.152.
 */
package mage.target;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.filter.FilterPlayer;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetImpl;

public class TargetPlayer
extends TargetImpl {
    protected final FilterPlayer filter;

    public TargetPlayer() {
        this(1, 1, false);
    }

    public TargetPlayer(FilterPlayer filter) {
        this(1, 1, false, filter);
    }

    public TargetPlayer(int numTargets) {
        this(numTargets, numTargets, false);
    }

    public TargetPlayer(int minNumTargets, int maxNumTargets, boolean notTarget) {
        this(minNumTargets, maxNumTargets, notTarget, new FilterPlayer());
    }

    public TargetPlayer(int minNumTargets, int maxNumTargets, boolean notTarget, FilterPlayer filter) {
        this.minNumberOfTargets = minNumTargets;
        this.maxNumberOfTargets = maxNumTargets;
        this.filter = filter;
        this.targetName = filter.getMessage();
        this.notTarget = notTarget;
    }

    protected TargetPlayer(TargetPlayer target) {
        super(target);
        this.filter = target.filter.copy();
    }

    @Override
    public FilterPlayer getFilter() {
        return this.filter;
    }

    @Override
    public boolean canChoose(UUID sourceControllerId, Ability source, Game game) {
        return this.canChooseFromPossibleTargets(sourceControllerId, source, game);
    }

    @Override
    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        HashSet<UUID> possibleTargets = new HashSet<UUID>();
        for (UUID playerId : game.getState().getPlayersInRange(sourceControllerId, game)) {
            Player player = game.getPlayer(playerId);
            if (player == null || !this.filter.match(player, sourceControllerId, source, game)) continue;
            possibleTargets.add(playerId);
        }
        return this.keepValidPossibleTargets(possibleTargets, sourceControllerId, source, game);
    }

    @Override
    public boolean isLegal(Ability source, Game game) {
        if (this.getMinNumberOfTargets() == 0 && this.targets.isEmpty()) {
            return true;
        }
        return this.targets.keySet().stream().anyMatch(playerId -> this.canTarget((UUID)playerId, source, game));
    }

    @Override
    public boolean canTarget(UUID id, Ability source, Game game) {
        Player player = game.getPlayer(id);
        if (player != null) {
            if (source != null) {
                return (this.isNotTarget() || player.canBeTargetedBy(game.getObject(source), source.getControllerId(), source, game)) && this.filter.match(player, source.getControllerId(), source, game);
            }
            return this.filter.match(player, game);
        }
        return false;
    }

    @Override
    public boolean canTarget(UUID playerId, UUID id, Ability source, Game game) {
        return this.canTarget(id, source, game);
    }

    @Override
    public String getTargetedName(Game game) {
        StringBuilder sb = new StringBuilder();
        for (UUID targetId : this.getTargets()) {
            Player player = game.getPlayer(targetId);
            if (player != null) {
                sb.append(player.getLogName()).append(' ');
                continue;
            }
            sb.append("[target missing]");
        }
        return sb.toString().trim();
    }

    @Override
    public TargetPlayer copy() {
        return new TargetPlayer(this);
    }
}

