/*
 * Decompiled with CFR 0.152.
 */
package mage.target.common;

import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.constants.ComparisonType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.FilterSpell;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.target.TargetCard;

public class TargetCardInGraveyardBattlefieldOrStack
extends TargetCard {
    private static final FilterSpell defaultSpellFilter = new FilterSpell();
    protected final FilterPermanent filterPermanent;
    protected final FilterSpell filterSpell;

    public TargetCardInGraveyardBattlefieldOrStack(int minNumTargets, int maxNumTargets, FilterCard filterGraveyard, FilterPermanent filterBattlefield) {
        this(minNumTargets, maxNumTargets, filterGraveyard, filterBattlefield, null);
    }

    public TargetCardInGraveyardBattlefieldOrStack(int minNumTargets, int maxNumTargets, FilterCard filterGraveyard, FilterPermanent filterBattlefield, String targetName) {
        this(minNumTargets, maxNumTargets, filterGraveyard, filterBattlefield, defaultSpellFilter, targetName);
    }

    public TargetCardInGraveyardBattlefieldOrStack(int minNumTargets, int maxNumTargets, FilterCard filterGraveyard, FilterPermanent filterBattlefield, FilterSpell filterSpell, String targetName) {
        super(minNumTargets, maxNumTargets, Zone.GRAVEYARD, filterGraveyard);
        this.filterPermanent = filterBattlefield;
        this.filterSpell = filterSpell;
        this.targetName = targetName != null ? targetName : this.filter.getMessage() + " in a graveyard" + (maxNumTargets > 1 ? " and/or " : " or ") + this.filterPermanent.getMessage() + " on the battlefield";
    }

    protected TargetCardInGraveyardBattlefieldOrStack(TargetCardInGraveyardBattlefieldOrStack target) {
        super(target);
        this.filterPermanent = target.filterPermanent;
        this.filterSpell = target.filterSpell;
    }

    @Override
    public boolean canChoose(UUID sourceControllerId, Ability source, Game game) {
        return this.canChooseFromPossibleTargets(sourceControllerId, source, game);
    }

    @Override
    public boolean canTarget(UUID id, Ability source, Game game) {
        return this.canTarget(source == null ? null : source.getControllerId(), id, source, game);
    }

    @Override
    public boolean canTarget(UUID playerId, UUID id, Ability source, Game game) {
        if (super.canTarget(playerId, id, source, game)) {
            return true;
        }
        Permanent permanent = game.getPermanent(id);
        if (permanent != null) {
            return playerId == null ? this.filterPermanent.match(permanent, game) : this.filterPermanent.match(permanent, playerId, source, game);
        }
        Spell spell = game.getSpell(id);
        return spell != null && (playerId == null ? this.filter.match(spell, game) : this.filterSpell.match(spell, playerId, source, game));
    }

    @Override
    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        Set<UUID> possibleTargets = super.possibleTargets(sourceControllerId, source, game);
        for (Permanent permanent : game.getBattlefield().getActivePermanents(this.filterPermanent, sourceControllerId, source, game)) {
            possibleTargets.add(permanent.getId());
        }
        for (StackObject stackObject : game.getStack()) {
            if (!(stackObject instanceof Spell) || !game.getState().getPlayersInRange(sourceControllerId, game).contains(stackObject.getControllerId()) || !this.filterSpell.match(stackObject, sourceControllerId, source, game)) continue;
            possibleTargets.add(stackObject.getId());
        }
        return this.keepValidPossibleTargets(possibleTargets, sourceControllerId, source, game);
    }

    @Override
    public TargetCardInGraveyardBattlefieldOrStack copy() {
        return new TargetCardInGraveyardBattlefieldOrStack(this);
    }

    static {
        defaultSpellFilter.add(new ManaValuePredicate(ComparisonType.FEWER_THAN, -1));
    }
}

