/*
 * Decompiled with CFR 0.152.
 */
package mage.target.common;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.MageItem;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

public class TargetCardInHand
extends TargetCard {
    public TargetCardInHand() {
        this(1, 1, StaticFilters.FILTER_CARD_A);
    }

    public TargetCardInHand(FilterCard filter) {
        this(1, 1, filter);
    }

    public TargetCardInHand(int numTargets, FilterCard filter) {
        this(numTargets, numTargets, filter);
    }

    public TargetCardInHand(int minNumTargets, int maxNumTargets, FilterCard filter) {
        super(minNumTargets, maxNumTargets, Zone.HAND, filter);
        this.withNotTarget(true);
    }

    protected TargetCardInHand(TargetCardInHand target) {
        super(target);
    }

    @Override
    public boolean canTarget(UUID playerId, UUID id, Ability source, Game game) {
        Card card = game.getCard(id);
        return game.getState().getZone(id) == Zone.HAND && game.getState().getPlayersInRange(this.getTargetController() == null ? playerId : this.getTargetController(), game).contains(game.getOwnerId(id)) && this.filter.match(card, game);
    }

    @Override
    public boolean canTarget(UUID id, Ability source, Game game) {
        return this.canTarget(source == null ? null : source.getControllerId(), id, source, game);
    }

    @Override
    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        HashSet<UUID> possibleTargets = new HashSet<UUID>();
        Player player = game.getPlayer(sourceControllerId);
        if (player != null) {
            player.getHand().getCards(this.filter, sourceControllerId, source, game).stream().map(MageItem::getId).forEach(possibleTargets::add);
        }
        return this.keepValidPossibleTargets(possibleTargets, sourceControllerId, source, game);
    }

    @Override
    public boolean canChoose(UUID sourceControllerId, Ability source, Game game) {
        return this.canChooseFromPossibleTargets(sourceControllerId, source, game);
    }

    @Override
    public TargetCardInHand copy() {
        return new TargetCardInHand(this);
    }

    @Override
    public String getTargetedName(Game game) {
        return this.filter.getMessage();
    }

    @Override
    public TargetCardInHand withChooseHint(String chooseHint) {
        super.withChooseHint(chooseHint);
        return this;
    }
}

