/*
 * Decompiled with CFR 0.152.
 */
package mage.target.common;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

public class TargetCardInYourGraveyard
extends TargetCard {
    public TargetCardInYourGraveyard() {
        this(1);
    }

    public TargetCardInYourGraveyard(int numTargets) {
        this(numTargets, numTargets);
    }

    public TargetCardInYourGraveyard(FilterCard filter) {
        this(1, filter);
    }

    public TargetCardInYourGraveyard(int numTargets, FilterCard filter) {
        this(numTargets, numTargets, filter);
    }

    public TargetCardInYourGraveyard(int minNumTargets, int maxNumTargets) {
        this(minNumTargets, maxNumTargets, maxNumTargets > 1 ? StaticFilters.FILTER_CARDS_FROM_YOUR_GRAVEYARD : StaticFilters.FILTER_CARD_FROM_YOUR_GRAVEYARD);
    }

    public TargetCardInYourGraveyard(int minNumTargets, int maxNumTargets, FilterCard filter) {
        this(minNumTargets, maxNumTargets, filter, false);
    }

    public TargetCardInYourGraveyard(int minNumTarget, int maxNumTargets, FilterCard filter, boolean notTarget) {
        super(minNumTarget, maxNumTargets, Zone.GRAVEYARD, filter);
        this.withNotTarget(notTarget);
    }

    protected TargetCardInYourGraveyard(TargetCardInYourGraveyard target) {
        super(target);
    }

    @Override
    public boolean canTarget(UUID id, Ability source, Game game) {
        Card card = game.getCard(id);
        if (card != null && game.getState().getZone(card.getId()) == Zone.GRAVEYARD && game.getPlayer(source.getControllerId()).getGraveyard().contains(id)) {
            return this.filter.match(card, source.getControllerId(), source, game);
        }
        return false;
    }

    @Override
    public boolean canTarget(UUID playerId, UUID id, Ability ability, Game game) {
        Card card = game.getCard(id);
        if (card != null && game.getState().getZone(card.getId()) == Zone.GRAVEYARD && game.getPlayer(playerId).getGraveyard().contains(id)) {
            return this.filter.match(card, game);
        }
        return false;
    }

    @Override
    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        HashSet<UUID> possibleTargets = new HashSet<UUID>();
        Player player = game.getPlayer(sourceControllerId);
        for (Card card : player.getGraveyard().getCards(this.filter, sourceControllerId, source, game)) {
            possibleTargets.add(card.getId());
        }
        return this.keepValidPossibleTargets(possibleTargets, sourceControllerId, source, game);
    }

    @Override
    public TargetCardInYourGraveyard copy() {
        return new TargetCardInYourGraveyard(this);
    }
}

