/*
 * Decompiled with CFR 0.152.
 */
package mage.target.common;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.constants.Zone;
import mage.filter.Filter;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterPermanentOrPlayer;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetImpl;

public class TargetPermanentOrPlayer
extends TargetImpl {
    protected FilterPermanentOrPlayer filter;

    public TargetPermanentOrPlayer() {
        this(1);
    }

    public TargetPermanentOrPlayer(int numTargets) {
        this(numTargets, numTargets);
    }

    public TargetPermanentOrPlayer(FilterPermanentOrPlayer filter) {
        this(1, 1, filter, false);
    }

    public TargetPermanentOrPlayer(int minNumTargets, int maxNumTargets) {
        this(minNumTargets, maxNumTargets, false);
    }

    public TargetPermanentOrPlayer(int minNumTargets, int maxNumTargets, boolean notTarget) {
        this(minNumTargets, maxNumTargets, new FilterPermanentOrPlayer(), notTarget);
    }

    public TargetPermanentOrPlayer(int minNumTargets, int maxNumTargets, FilterPermanentOrPlayer filter, boolean notTarget) {
        this.minNumberOfTargets = minNumTargets;
        this.maxNumberOfTargets = maxNumTargets;
        this.zone = Zone.ALL;
        this.filter = filter;
        this.targetName = filter.getMessage();
        this.notTarget = notTarget;
    }

    protected TargetPermanentOrPlayer(TargetPermanentOrPlayer target) {
        super(target);
        this.filter = target.filter.copy();
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public boolean canTarget(UUID playerId, UUID id, Ability source, Game game) {
        return this.canTarget(id, source, game);
    }

    @Override
    public boolean canTarget(UUID id, Ability source, Game game) {
        Permanent permanent = game.getPermanent(id);
        Player player = game.getPlayer(id);
        if (source != null) {
            MageObject targetSource = game.getObject(source);
            if (permanent != null) {
                if (!(this.isNotTarget() || permanent.canBeTargetedBy(game.getObject(source.getId()), source.getControllerId(), source, game) && permanent.canBeTargetedBy(game.getObject(source), source.getControllerId(), source, game))) {
                    return false;
                }
                return this.filter.match(permanent, source.getControllerId(), source, game);
            }
            if (player != null) {
                if (!(this.isNotTarget() || player.canBeTargetedBy(targetSource, source.getControllerId(), source, game) && this.filter.match(player, source.getControllerId(), source, game))) {
                    return false;
                }
                return this.filter.match(player, game);
            }
        }
        if (permanent != null) {
            return this.filter.match(permanent, game);
        }
        return this.filter.match(player, game);
    }

    @Override
    public boolean canChoose(UUID sourceControllerId, Ability source, Game game) {
        int count = 0;
        MageObject targetSource = game.getObject(source);
        for (UUID playerId : game.getState().getPlayersInRange(sourceControllerId, game)) {
            Player player = game.getPlayer(playerId);
            if (player == null || !player.canBeTargetedBy(targetSource, sourceControllerId, source, game) || !this.filter.match(player, sourceControllerId, source, game) || ++count < this.minNumberOfTargets) continue;
            return true;
        }
        for (Permanent permanent : game.getBattlefield().getActivePermanents(this.filter.getPermanentFilter(), sourceControllerId, game)) {
            if (!permanent.canBeTargetedBy(targetSource, sourceControllerId, source, game) || !this.filter.match(permanent, sourceControllerId, source, game) || ++count < this.minNumberOfTargets) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canChoose(UUID sourceControllerId, Game game) {
        int count = 0;
        for (UUID playerId : game.getState().getPlayersInRange(sourceControllerId, game)) {
            Player player = game.getPlayer(playerId);
            if (player == null || !this.filter.getPlayerFilter().match(player, game) || ++count < this.minNumberOfTargets) continue;
            return true;
        }
        for (Permanent permanent : game.getBattlefield().getActivePermanents(this.filter.getPermanentFilter(), sourceControllerId, game)) {
            if (!this.filter.match(permanent, sourceControllerId, (Ability)null, game) || !this.filter.match(permanent, game) || ++count < this.minNumberOfTargets) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        HashSet<UUID> possibleTargets = new HashSet<UUID>();
        MageObject targetSource = game.getObject(source);
        for (UUID playerId : game.getState().getPlayersInRange(sourceControllerId, game)) {
            Player player = game.getPlayer(playerId);
            if (player == null || !this.filter.match(player, sourceControllerId, source, game)) continue;
            possibleTargets.add(playerId);
        }
        for (Permanent permanent : game.getBattlefield().getActivePermanents(this.filter.getPermanentFilter(), sourceControllerId, game)) {
            if (!this.filter.match(permanent, sourceControllerId, source, game)) continue;
            possibleTargets.add(permanent.getId());
        }
        return this.keepValidPossibleTargets(possibleTargets, sourceControllerId, source, game);
    }

    @Override
    public String getTargetedName(Game game) {
        StringBuilder sb = new StringBuilder();
        for (UUID targetId : this.getTargets()) {
            Permanent permanent = game.getPermanent(targetId);
            if (permanent != null) {
                sb.append(permanent.getLogName()).append(' ');
                continue;
            }
            Player player = game.getPlayer(targetId);
            if (player != null) {
                sb.append(player.getLogName()).append(' ');
                continue;
            }
            MageObject object = game.getObject(targetId);
            if (object != null) {
                sb.append(object.getLogName()).append(' ');
                continue;
            }
            sb.append("ERROR");
        }
        return sb.toString().trim();
    }

    @Override
    public TargetPermanentOrPlayer copy() {
        return new TargetPermanentOrPlayer(this);
    }

    public FilterPermanent getFilterPermanent() {
        return this.filter.getPermanentFilter().copy();
    }
}

