/*
 * Decompiled with CFR 0.152.
 */
package mage.target.common;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.constants.Zone;
import mage.filter.Filter;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterSpellOrPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.target.TargetImpl;
import mage.util.GameLog;

public class TargetSpellOrPermanent
extends TargetImpl {
    protected FilterSpellOrPermanent filter;

    public TargetSpellOrPermanent() {
        this(1);
    }

    public TargetSpellOrPermanent(FilterSpellOrPermanent filter) {
        this(1, 1, filter, false);
    }

    public TargetSpellOrPermanent(int numTargets) {
        this(numTargets, numTargets);
    }

    public TargetSpellOrPermanent(int minNumTargets, int maxNumTargets) {
        this(minNumTargets, maxNumTargets, false);
    }

    public TargetSpellOrPermanent(int minNumTargets, int maxNumTargets, boolean notTarget) {
        this(minNumTargets, maxNumTargets, new FilterSpellOrPermanent(), notTarget);
        this.notTarget = notTarget;
    }

    public TargetSpellOrPermanent(int minNumTargets, int maxNumTargets, FilterSpellOrPermanent filter, boolean notTarget) {
        super(notTarget);
        this.minNumberOfTargets = minNumTargets;
        this.maxNumberOfTargets = maxNumTargets;
        this.zone = Zone.ALL;
        this.notTarget = notTarget;
        this.filter = filter;
        this.targetName = filter.getMessage();
    }

    protected TargetSpellOrPermanent(TargetSpellOrPermanent target) {
        super(target);
        this.filter = target.filter.copy();
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    public FilterPermanent getPermanentFilter() {
        return this.filter.getPermanentFilter();
    }

    public void setFilter(FilterSpellOrPermanent filter) {
        this.filter = filter;
    }

    @Override
    public boolean canTarget(UUID id, Ability source, Game game) {
        Permanent permanent = game.getPermanent(id);
        if (permanent != null) {
            if (source != null) {
                return (this.isNotTarget() || permanent.canBeTargetedBy(game.getObject(source), source.getControllerId(), source, game)) && this.filter.match(permanent, source.getControllerId(), source, game);
            }
            return this.filter.match(permanent, game);
        }
        Spell spell = game.getStack().getSpell(id);
        return spell != null && !source.getSourceId().equals(id) && this.filter.match(spell, game);
    }

    @Override
    public boolean canTarget(UUID playerId, UUID id, Ability source, Game game) {
        return this.canTarget(id, source, game);
    }

    @Override
    public boolean canChoose(UUID sourceControllerId, Ability source, Game game) {
        int count = 0;
        MageObject targetSource = game.getObject(source);
        for (StackObject stackObject : game.getStack()) {
            Spell spell = game.getStack().getSpell(stackObject.getId());
            if (spell == null || source.getSourceId().equals(spell.getSourceId()) || !this.filter.match(spell, sourceControllerId, source, game) || ++count < this.minNumberOfTargets) continue;
            return true;
        }
        for (Permanent permanent : game.getBattlefield().getActivePermanents(this.filter.getPermanentFilter(), sourceControllerId, game)) {
            if (!permanent.canBeTargetedBy(targetSource, sourceControllerId, source, game) || !this.filter.match(permanent, sourceControllerId, source, game) || ++count < this.minNumberOfTargets) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canChoose(UUID sourceControllerId, Game game) {
        int count = 0;
        for (StackObject stackObject : game.getStack()) {
            Spell spell = game.getStack().getSpell(stackObject.getId());
            if (spell == null || !this.filter.match(spell, sourceControllerId, (Ability)null, game) || !this.filter.match(spell, game) || ++count < this.minNumberOfTargets) continue;
            return true;
        }
        for (Permanent permanent : game.getBattlefield().getActivePermanents(this.filter.getPermanentFilter(), sourceControllerId, game)) {
            if (!this.filter.match(permanent, sourceControllerId, (Ability)null, game) || !this.filter.match(permanent, game) || ++count < this.minNumberOfTargets) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        HashSet<UUID> possibleTargets = new HashSet<UUID>();
        MageObject targetSource = game.getObject(source);
        for (StackObject stackObject : game.getStack()) {
            Spell spell = game.getStack().getSpell(stackObject.getId());
            if (spell == null || targetSource == null || targetSource.getId().equals(spell.getSourceId()) || !this.filter.match(spell, sourceControllerId, source, game)) continue;
            possibleTargets.add(spell.getId());
        }
        for (Permanent permanent : game.getBattlefield().getActivePermanents(this.filter.getPermanentFilter(), sourceControllerId, game)) {
            if (!this.filter.match(permanent, sourceControllerId, source, game)) continue;
            possibleTargets.add(permanent.getId());
        }
        return this.keepValidPossibleTargets(possibleTargets, sourceControllerId, source, game);
    }

    @Override
    public String getTargetedName(Game game) {
        StringBuilder sb = new StringBuilder();
        for (UUID targetId : this.getTargets()) {
            Permanent permanent = game.getPermanent(targetId);
            if (permanent != null) {
                sb.append(permanent.getLogName()).append(' ');
                continue;
            }
            Spell spell = game.getStack().getSpell(targetId);
            if (spell == null) continue;
            if (spell.isFaceDown(game)) {
                sb.append(GameLog.getNeutralColoredText("face down spell"));
                continue;
            }
            sb.append(spell.getLogName()).append(' ');
        }
        return sb.toString().trim();
    }

    @Override
    public TargetSpellOrPermanent copy() {
        return new TargetSpellOrPermanent(this);
    }
}

