/*
 * Decompiled with CFR 0.152.
 */
package mage.target.targetadjustment;

import java.util.UUID;
import java.util.stream.Stream;
import mage.abilities.Ability;
import mage.filter.Filter;
import mage.filter.predicate.card.OwnerIdPredicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.targetadjustment.GenericTargetAdjuster;
import mage.util.CardUtil;

public class ForEachPlayerTargetsAdjuster
extends GenericTargetAdjuster {
    private final boolean owner;
    private final boolean onlyOpponents;

    public ForEachPlayerTargetsAdjuster(boolean owner, boolean onlyOpponents) {
        this.owner = owner;
        this.onlyOpponents = onlyOpponents;
    }

    @Override
    public void addDefaultTargets(Ability ability) {
        super.addDefaultTargets(ability);
        if (this.blueprintTarget instanceof TargetCard && !this.owner) {
            throw new IllegalArgumentException("EachOpponentPermanentTargetsAdjuster has TargetCard but checking for Controller instead of Owner - " + this.blueprintTarget);
        }
        CardUtil.AssertNoControllerOwnerPredicates(this.blueprintTarget);
    }

    @Override
    public void adjustTargets(Ability ability, Game game) {
        ability.getTargets().clear();
        Stream ids = this.onlyOpponents ? game.getOpponents(ability.getControllerId()).stream() : game.getState().getPlayersInRange(ability.getControllerId(), game).stream();
        ids.forEach(id -> {
            Player opponent = game.getPlayer((UUID)id);
            if (opponent == null) {
                return;
            }
            Target newTarget = this.blueprintTarget.copy();
            Filter filter = newTarget.getFilter();
            if (this.owner) {
                filter.add(new OwnerIdPredicate((UUID)id));
                newTarget.withTargetName(filter.getMessage() + " (owned by " + opponent.getLogName() + ")");
            } else {
                filter.add(new ControllerIdPredicate((UUID)id));
                newTarget.withTargetName(filter.getMessage() + " (controlled by " + opponent.getLogName() + ")");
            }
            ability.addTarget(newTarget);
        });
    }
}

