/*
 * Decompiled with CFR 0.152.
 */
package mage.target.targetadjustment;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.filter.Filter;
import mage.filter.predicate.card.OwnerIdPredicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.targetadjustment.GenericTargetAdjuster;
import mage.target.targetpointer.FirstTargetPointer;
import mage.util.CardUtil;

public class ThatPlayerControlsTargetAdjuster
extends GenericTargetAdjuster {
    private final boolean owner;

    public ThatPlayerControlsTargetAdjuster() {
        this(false);
    }

    public ThatPlayerControlsTargetAdjuster(boolean owner) {
        this.owner = owner;
    }

    @Override
    public void addDefaultTargets(Ability ability) {
        super.addDefaultTargets(ability);
        if (this.blueprintTarget instanceof TargetCard && !this.owner) {
            throw new IllegalArgumentException("DamagedPlayerControlsTargetAdjuster has TargetCard but checking for Controller instead of Owner - " + this.blueprintTarget);
        }
        CardUtil.AssertNoControllerOwnerPredicates(this.blueprintTarget);
    }

    @Override
    public void adjustTargets(Ability ability, Game game) {
        UUID opponentId = ((Effect)ability.getEffects().get(0)).getTargetPointer().getFirst(game, ability);
        Player opponent = game.getPlayer(opponentId);
        ability.getTargets().clear();
        ability.getAllEffects().setTargetPointer(new FirstTargetPointer());
        if (opponent == null) {
            return;
        }
        Target newTarget = this.blueprintTarget.copy();
        Filter filter = newTarget.getFilter();
        if (this.owner) {
            filter.add(new OwnerIdPredicate(opponentId));
            newTarget.withTargetName(filter.getMessage() + " (owned by " + opponent.getLogName() + ")");
        } else {
            filter.add(new ControllerIdPredicate(opponentId));
            newTarget.withTargetName(filter.getMessage() + " (controlled by " + opponent.getLogName() + ")");
        }
        ability.addTarget(newTarget);
    }
}

