/*
 * Decompiled with CFR 0.152.
 */
package mage.target.targetpointer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.TargetPointerImpl;

public class FixedTarget
extends TargetPointerImpl {
    private final UUID targetId;
    private int zoneChangeCounter = 0;

    public FixedTarget(UUID target) {
        this.targetId = target;
    }

    public FixedTarget(MageObjectReference mor) {
        this(mor.getSourceId(), mor.getZoneChangeCounter());
    }

    public FixedTarget(Card card, Game game) {
        this.targetId = card.getId();
        this.zoneChangeCounter = card.getZoneChangeCounter(game);
        this.setInitialized();
    }

    public FixedTarget(Permanent permanent, Game game) {
        this(permanent.getId(), game);
    }

    public FixedTarget(UUID targetId, int zoneChangeCounter) {
        this.targetId = targetId;
        this.zoneChangeCounter = zoneChangeCounter;
        this.setInitialized();
    }

    public FixedTarget(UUID targetId, Game game) {
        this.targetId = targetId;
        this.zoneChangeCounter = game.getState().getZoneChangeCounter(targetId);
        this.setInitialized();
    }

    protected FixedTarget(FixedTarget targetPointer) {
        super(targetPointer);
        this.targetId = targetPointer.targetId;
        this.zoneChangeCounter = targetPointer.zoneChangeCounter;
    }

    @Override
    public void init(Game game, Ability source) {
        if (this.isInitialized()) {
            return;
        }
        this.setInitialized();
        this.zoneChangeCounter = game.getState().getZoneChangeCounter(this.targetId);
    }

    @Override
    public List<UUID> getTargets(Game game, Ability source) {
        Card card;
        if (this.zoneChangeCounter > 0 && (card = game.getCard(this.targetId)) != null && card.getZoneChangeCounter(game) != this.zoneChangeCounter) {
            return Collections.emptyList();
        }
        ArrayList<UUID> list = new ArrayList<UUID>();
        if (this.targetId != null) {
            list.add(this.targetId);
        }
        return list;
    }

    @Override
    public UUID getFirst(Game game, Ability source) {
        Card card;
        if (this.zoneChangeCounter > 0 && (card = game.getCard(this.targetId)) != null && card.getZoneChangeCounter(game) != this.zoneChangeCounter) {
            return null;
        }
        return this.targetId;
    }

    @Override
    public FixedTarget copy() {
        return new FixedTarget(this);
    }

    public UUID getTarget() {
        return this.targetId;
    }

    public int getZoneChangeCounter() {
        return this.zoneChangeCounter;
    }

    @Override
    public Permanent getFirstTargetPermanentOrLKI(Game game, Ability source) {
        this.init(game, source);
        Permanent permanent = game.getPermanent(this.targetId);
        if (permanent != null && permanent.getZoneChangeCounter(game) == this.zoneChangeCounter) {
            return permanent;
        }
        MageObject mageObject = game.getLastKnownInformation(this.targetId, Zone.BATTLEFIELD, this.zoneChangeCounter);
        if (mageObject instanceof Permanent) {
            return (Permanent)mageObject;
        }
        return null;
    }
}

