/*
 * Decompiled with CFR 0.152.
 */
package mage.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;

public class CircularList<E>
implements List<E>,
Iterable<E>,
Serializable {
    protected final List<E> list = new ArrayList();
    protected final ReentrantLock lock = new ReentrantLock();
    protected int modCount;
    protected int index;

    public CircularList() {
    }

    public CircularList(CircularList<E> cList) {
        this.modCount = cList.modCount;
        for (E entry : cList.list) {
            this.list.add(entry);
        }
        this.index = cList.index;
    }

    public CircularList<E> copy() {
        return new CircularList<E>(this);
    }

    @Override
    public boolean add(E element) {
        this.add(this.index, element);
        return true;
    }

    @Override
    public void add(int index, E element) {
        this.lock.lock();
        try {
            this.list.add(index, element);
            ++this.modCount;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean setCurrent(E element) {
        if (this.list.contains(element)) {
            this.index = this.list.indexOf(element);
            return true;
        }
        return false;
    }

    public E get() {
        return this.get(this.index);
    }

    @Override
    public E get(int index) {
        if (this.list.size() > index) {
            return this.list.get(index);
        }
        return null;
    }

    public E getNext() {
        return this.list.get(this.incrementPointer());
    }

    public E getPrevious() {
        return this.list.get(this.decrementPointer());
    }

    public boolean remove() {
        return this.remove(this.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E remove(int index) {
        this.lock.lock();
        try {
            E ret = this.list.remove(index);
            this.fixInvalidPointer();
            ++this.modCount;
            E e = ret;
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        this.lock.lock();
        try {
            boolean ret = this.list.remove(o);
            this.fixInvalidPointer();
            ++this.modCount;
            boolean bl = ret;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private int incrementPointer() {
        this.lock.lock();
        try {
            int n = this.index = this.findNextListPointer(this.index);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    private int findNextListPointer(int currentIndex) {
        if (++currentIndex >= this.list.size()) {
            currentIndex = 0;
        }
        return currentIndex;
    }

    private int decrementPointer() {
        this.lock.lock();
        try {
            int n = this.index = this.findPrevListPointer(this.index);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    private int findPrevListPointer(int currentIndex) {
        if (--currentIndex < 0) {
            currentIndex = this.list.size() - 1;
        }
        return currentIndex;
    }

    private void fixInvalidPointer() {
        if (this.index > this.list.size()) {
            this.index = this.list.size() - 1;
        } else if (this.index < 0) {
            this.index = 0;
        }
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new UUID[0]);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        T[] res = this.list.toArray(a);
        Iterator<E> iter = this.iterator();
        int insertIndex = 0;
        while (iter.hasNext()) {
            res[insertIndex] = iter.next();
            ++insertIndex;
        }
        return res;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.addAll(this.index, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.lock.lock();
        try {
            ++this.modCount;
            boolean bl = this.list.addAll(index, c);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> c) {
        this.lock.lock();
        try {
            boolean ret = this.list.removeAll(c);
            ++this.modCount;
            this.fixInvalidPointer();
            boolean bl = ret;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> c) {
        this.lock.lock();
        try {
            boolean ret = this.list.retainAll(c);
            ++this.modCount;
            this.fixInvalidPointer();
            boolean bl = ret;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void clear() {
        this.lock.lock();
        try {
            this.list.clear();
            ++this.modCount;
            this.index = 0;
        }
        finally {
            this.lock.unlock();
        }
    }

    public E set(E element) {
        return this.set(this.index, element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E set(int index, E element) {
        this.lock.lock();
        try {
            ++this.modCount;
            E e = this.list.set(index, element);
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    @Override
    public Iterator<E> iterator() {
        return new CircularIterator();
    }

    @Override
    public ListIterator<E> listIterator() {
        return new CircularListIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new CircularListIterator(index);
    }

    private class CircularListIterator<E>
    implements ListIterator<E> {
        int cursor;
        final int lastIndex;
        final int firstIndex;
        final int curModCount;
        boolean hasMoved = false;

        private CircularListIterator() {
            this(circularList.index);
        }

        private CircularListIterator(int index) {
            this.curModCount = CircularList.this.modCount;
            this.cursor = index;
            this.firstIndex = index;
            this.lastIndex = index;
        }

        @Override
        public boolean hasNext() {
            if (!this.hasMoved && CircularList.this.size() > 0) {
                return true;
            }
            return this.cursor != this.lastIndex;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new IllegalStateException();
            }
            if (this.curModCount != CircularList.this.modCount) {
                throw new ConcurrentModificationException();
            }
            Object data = CircularList.this.list.get(this.cursor);
            this.cursor = CircularList.this.findNextListPointer(this.cursor);
            this.hasMoved = true;
            return data;
        }

        @Override
        public boolean hasPrevious() {
            if (!this.hasMoved && CircularList.this.size() > 0) {
                return true;
            }
            return this.cursor != this.firstIndex;
        }

        @Override
        public E previous() {
            if (!this.hasPrevious()) {
                throw new IllegalStateException();
            }
            if (this.curModCount != CircularList.this.modCount) {
                throw new ConcurrentModificationException();
            }
            this.cursor = CircularList.this.findPrevListPointer(this.cursor);
            this.hasMoved = true;
            return CircularList.this.list.get(this.cursor);
        }

        @Override
        public int nextIndex() {
            if (this.hasNext()) {
                return CircularList.this.findNextListPointer(this.cursor);
            }
            return CircularList.this.list.size();
        }

        @Override
        public int previousIndex() {
            if (this.hasPrevious()) {
                return CircularList.this.findPrevListPointer(this.cursor);
            }
            return -1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void set(E arg0) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void add(E arg0) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private class CircularIterator<E>
    implements Iterator<E> {
        int cursor;
        final int lastIndex;
        final int curModCount;
        boolean hasMoved = false;

        private CircularIterator() {
            this.curModCount = CircularList.this.modCount;
            this.lastIndex = this.cursor = CircularList.this.index;
        }

        @Override
        public boolean hasNext() {
            if (!this.hasMoved && CircularList.this.size() > 0) {
                return true;
            }
            return this.cursor != this.lastIndex;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new IllegalStateException();
            }
            if (this.curModCount != CircularList.this.modCount) {
                throw new ConcurrentModificationException();
            }
            Object data = CircularList.this.list.get(this.cursor);
            this.cursor = CircularList.this.findNextListPointer(this.cursor);
            this.hasMoved = true;
            return data;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

