/*
 * Decompiled with CFR 0.152.
 */
package mage.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.Mana;
import mage.ManaSymbol;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.VariableCostType;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.costs.mana.AlternateManaPaymentAbility;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.costs.mana.ManaSymbols;
import mage.abilities.costs.mana.VariableManaCost;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.GetXValue;
import mage.abilities.effects.Effect;
import mage.abilities.mana.ActivatedManaAbilityImpl;
import mage.abilities.mana.AnyColorManaAbility;
import mage.abilities.mana.BasicManaAbility;
import mage.abilities.mana.BlackManaAbility;
import mage.abilities.mana.BlueManaAbility;
import mage.abilities.mana.GreenManaAbility;
import mage.abilities.mana.RedManaAbility;
import mage.abilities.mana.WhiteManaAbility;
import mage.cards.Card;
import mage.cards.CardWithSpellOption;
import mage.cards.ModalDoubleFacedCard;
import mage.cards.SplitCard;
import mage.choices.Choice;
import mage.constants.ColoredManaSymbol;
import mage.constants.ManaType;
import mage.filter.FilterMana;
import mage.game.Game;
import mage.game.permanent.token.Token;
import mage.players.Player;

public final class ManaUtil {
    private static final String regexBlack = ".*\\x7b.{0,2}B.{0,2}\\x7d.*";
    private static final String regexBlue = ".*\\x7b.{0,2}U.{0,2}\\x7d.*";
    private static final String regexRed = ".*\\x7b.{0,2}R.{0,2}\\x7d.*";
    private static final String regexGreen = ".*\\x7b.{0,2}G.{0,2}\\x7d.*";
    private static final String regexWhite = ".*\\x7b.{0,2}W.{0,2}\\x7d.*";

    private ManaUtil() {
    }

    public static Map<UUID, ActivatedManaAbilityImpl> tryToAutoPay(ManaCost unpaid, Map<UUID, ActivatedManaAbilityImpl> useableAbilities) {
        for (ActivatedManaAbilityImpl ability : useableAbilities.values()) {
            if (ability instanceof BasicManaAbility || ability instanceof AnyColorManaAbility) continue;
            return useableAbilities;
        }
        if (unpaid != null) {
            ManaSymbols symbols = ManaSymbols.buildFromManaCost(unpaid);
            Mana unpaidMana = unpaid.getMana();
            if (!symbols.isEmpty()) {
                return ManaUtil.getManaAbilitiesUsingManaSymbols(useableAbilities, symbols, unpaidMana);
            }
            return ManaUtil.getManaAbilitiesUsingMana(unpaid, useableAbilities);
        }
        return useableAbilities;
    }

    public static boolean tryToAutoSelectAManaColor(Choice choice, ManaCost unpaid) {
        String colorToAutoPay = null;
        if (unpaid.containsColor(ColoredManaSymbol.W) && choice.getChoices().contains("White")) {
            colorToAutoPay = "White";
        }
        if (unpaid.containsColor(ColoredManaSymbol.R) && choice.getChoices().contains("Red")) {
            if (colorToAutoPay != null) {
                return false;
            }
            colorToAutoPay = "Red";
        }
        if (unpaid.containsColor(ColoredManaSymbol.G) && choice.getChoices().contains("Green")) {
            if (colorToAutoPay != null) {
                return false;
            }
            colorToAutoPay = "Green";
        }
        if (unpaid.containsColor(ColoredManaSymbol.U) && choice.getChoices().contains("Blue")) {
            if (colorToAutoPay != null) {
                return false;
            }
            colorToAutoPay = "Blue";
        }
        if (unpaid.containsColor(ColoredManaSymbol.B) && choice.getChoices().contains("Black")) {
            if (colorToAutoPay != null) {
                return false;
            }
            colorToAutoPay = "Black";
        }
        if (unpaid.getMana().getDifferentColors() == 0) {
            colorToAutoPay = choice.getChoices().iterator().next();
        }
        if (colorToAutoPay != null) {
            choice.setChoice(colorToAutoPay);
            return true;
        }
        return false;
    }

    private static Map<UUID, ActivatedManaAbilityImpl> getManaAbilitiesUsingManaSymbols(Map<UUID, ActivatedManaAbilityImpl> useableAbilities, ManaSymbols symbols, Mana unpaidMana) {
        HashSet<ManaSymbol> countColored = new HashSet<ManaSymbol>();
        ActivatedManaAbilityImpl chosenManaAbility = null;
        for (ActivatedManaAbilityImpl ability : useableAbilities.values()) {
            chosenManaAbility = ManaUtil.getManaAbility(symbols, countColored, chosenManaAbility, ability);
            ActivatedManaAbilityImpl chosenManaAbilityForHybrid = ManaUtil.checkRedMana(symbols, countColored, ability);
            chosenManaAbility = chosenManaAbilityForHybrid != null ? chosenManaAbilityForHybrid : chosenManaAbility;
            chosenManaAbilityForHybrid = ManaUtil.checkBlackMana(symbols, countColored, ability);
            chosenManaAbility = chosenManaAbilityForHybrid != null ? chosenManaAbilityForHybrid : chosenManaAbility;
            chosenManaAbilityForHybrid = ManaUtil.checkBlueMana(symbols, countColored, ability);
            chosenManaAbility = chosenManaAbilityForHybrid != null ? chosenManaAbilityForHybrid : chosenManaAbility;
            chosenManaAbilityForHybrid = ManaUtil.checkWhiteMana(symbols, countColored, ability);
            chosenManaAbility = chosenManaAbilityForHybrid != null ? chosenManaAbilityForHybrid : chosenManaAbility;
            chosenManaAbilityForHybrid = ManaUtil.checkGreenMana(symbols, countColored, ability);
            chosenManaAbility = chosenManaAbilityForHybrid != null ? chosenManaAbilityForHybrid : chosenManaAbility;
        }
        if (countColored.isEmpty()) {
            if (unpaidMana.getGeneric() > 0) {
                return ManaUtil.replace(useableAbilities, useableAbilities.values().iterator().next());
            }
            return useableAbilities;
        }
        if (countColored.size() > 1) {
            HashSet<ManaSymbol> temp = new HashSet<ManaSymbol>();
            temp.addAll(countColored);
            for (ManaSymbol manaSymbol : countColored) {
                if (!manaSymbol.isHybrid()) continue;
                boolean found1 = countColored.contains((Object)manaSymbol.getManaSymbol1());
                boolean found2 = countColored.contains((Object)manaSymbol.getManaSymbol2());
                if (found1 && !found2) {
                    temp.remove((Object)manaSymbol);
                    continue;
                }
                if (found1 || !found2) continue;
                temp.remove((Object)manaSymbol);
            }
            if (temp.size() == 1) {
                for (ActivatedManaAbilityImpl ability : useableAbilities.values()) {
                    chosenManaAbility = ManaUtil.getManaAbility(symbols, countColored, chosenManaAbility, ability);
                }
                return ManaUtil.replace(useableAbilities, chosenManaAbility);
            }
            return useableAbilities;
        }
        return ManaUtil.replace(useableAbilities, chosenManaAbility);
    }

    private static ActivatedManaAbilityImpl getManaAbility(ManaSymbols symbols, Set<ManaSymbol> countColored, ActivatedManaAbilityImpl chosenManaAbility, ActivatedManaAbilityImpl ability) {
        if (ability instanceof RedManaAbility && symbols.contains((Object)ManaSymbol.R)) {
            chosenManaAbility = ability;
            countColored.add(ManaSymbol.R);
        }
        if (ability instanceof BlackManaAbility && symbols.contains((Object)ManaSymbol.B)) {
            chosenManaAbility = ability;
            countColored.add(ManaSymbol.B);
        }
        if (ability instanceof BlueManaAbility && symbols.contains((Object)ManaSymbol.U)) {
            chosenManaAbility = ability;
            countColored.add(ManaSymbol.U);
        }
        if (ability instanceof WhiteManaAbility && symbols.contains((Object)ManaSymbol.W)) {
            chosenManaAbility = ability;
            countColored.add(ManaSymbol.W);
        }
        if (ability instanceof GreenManaAbility && symbols.contains((Object)ManaSymbol.G)) {
            chosenManaAbility = ability;
            countColored.add(ManaSymbol.G);
        }
        return chosenManaAbility;
    }

    private static int countUniqueHybridSymbols(Set<ManaSymbol> symbols) {
        int count = 0;
        for (ManaSymbol symbol : symbols) {
            if (!symbol.isHybrid()) continue;
            ++count;
        }
        return count;
    }

    private static ActivatedManaAbilityImpl checkBlackMana(ManaSymbols symbols, Set<ManaSymbol> countColored, ActivatedManaAbilityImpl ability) {
        ActivatedManaAbilityImpl chosenManaAbilityForHybrid = null;
        if (ability instanceof BlackManaAbility) {
            if (symbols.contains((Object)ManaSymbol.HYBRID_BR)) {
                chosenManaAbilityForHybrid = ability;
                countColored.add(ManaSymbol.HYBRID_BR);
            } else if (symbols.contains((Object)ManaSymbol.HYBRID_BG)) {
                chosenManaAbilityForHybrid = ability;
                countColored.add(ManaSymbol.HYBRID_BG);
            } else if (symbols.contains((Object)ManaSymbol.HYBRID_UB)) {
                chosenManaAbilityForHybrid = ability;
                countColored.add(ManaSymbol.HYBRID_UB);
            } else if (symbols.contains((Object)ManaSymbol.HYBRID_WB)) {
                chosenManaAbilityForHybrid = ability;
                countColored.add(ManaSymbol.HYBRID_WB);
            } else if (symbols.contains((Object)ManaSymbol.HYBRID_CB)) {
                chosenManaAbilityForHybrid = ability;
                countColored.add(ManaSymbol.HYBRID_CB);
            }
        }
        return chosenManaAbilityForHybrid;
    }

    private static ActivatedManaAbilityImpl checkRedMana(ManaSymbols symbols, Set<ManaSymbol> countColored, ActivatedManaAbilityImpl ability) {
        ActivatedManaAbilityImpl chosenManaAbilityForHybrid = null;
        if (ability instanceof RedManaAbility) {
            if (symbols.contains((Object)ManaSymbol.HYBRID_BR)) {
                chosenManaAbilityForHybrid = ability;
                countColored.add(ManaSymbol.HYBRID_BR);
            } else if (symbols.contains((Object)ManaSymbol.HYBRID_RG)) {
                chosenManaAbilityForHybrid = ability;
                countColored.add(ManaSymbol.HYBRID_RG);
            } else if (symbols.contains((Object)ManaSymbol.HYBRID_RW)) {
                chosenManaAbilityForHybrid = ability;
                countColored.add(ManaSymbol.HYBRID_RW);
            } else if (symbols.contains((Object)ManaSymbol.HYBRID_UR)) {
                chosenManaAbilityForHybrid = ability;
                countColored.add(ManaSymbol.HYBRID_UR);
            } else if (symbols.contains((Object)ManaSymbol.HYBRID_CR)) {
                chosenManaAbilityForHybrid = ability;
                countColored.add(ManaSymbol.HYBRID_CR);
            }
        }
        return chosenManaAbilityForHybrid;
    }

    private static ActivatedManaAbilityImpl checkBlueMana(ManaSymbols symbols, Set<ManaSymbol> countColored, ActivatedManaAbilityImpl ability) {
        ActivatedManaAbilityImpl chosenManaAbilityForHybrid = null;
        if (ability instanceof BlueManaAbility) {
            if (symbols.contains((Object)ManaSymbol.HYBRID_UB)) {
                chosenManaAbilityForHybrid = ability;
                countColored.add(ManaSymbol.HYBRID_UB);
            } else if (symbols.contains((Object)ManaSymbol.HYBRID_UR)) {
                chosenManaAbilityForHybrid = ability;
                countColored.add(ManaSymbol.HYBRID_UR);
            } else if (symbols.contains((Object)ManaSymbol.HYBRID_WU)) {
                chosenManaAbilityForHybrid = ability;
                countColored.add(ManaSymbol.HYBRID_WU);
            } else if (symbols.contains((Object)ManaSymbol.HYBRID_GU)) {
                chosenManaAbilityForHybrid = ability;
                countColored.add(ManaSymbol.HYBRID_GU);
            } else if (symbols.contains((Object)ManaSymbol.HYBRID_CU)) {
                chosenManaAbilityForHybrid = ability;
                countColored.add(ManaSymbol.HYBRID_CU);
            }
        }
        return chosenManaAbilityForHybrid;
    }

    private static ActivatedManaAbilityImpl checkWhiteMana(ManaSymbols symbols, Set<ManaSymbol> countColored, ActivatedManaAbilityImpl ability) {
        ActivatedManaAbilityImpl chosenManaAbilityForHybrid = null;
        if (ability instanceof WhiteManaAbility) {
            if (symbols.contains((Object)ManaSymbol.HYBRID_WU)) {
                chosenManaAbilityForHybrid = ability;
                countColored.add(ManaSymbol.HYBRID_WU);
            } else if (symbols.contains((Object)ManaSymbol.HYBRID_WB)) {
                chosenManaAbilityForHybrid = ability;
                countColored.add(ManaSymbol.HYBRID_WB);
            } else if (symbols.contains((Object)ManaSymbol.HYBRID_GW)) {
                chosenManaAbilityForHybrid = ability;
                countColored.add(ManaSymbol.HYBRID_GW);
            } else if (symbols.contains((Object)ManaSymbol.HYBRID_RW)) {
                chosenManaAbilityForHybrid = ability;
                countColored.add(ManaSymbol.HYBRID_RW);
            } else if (symbols.contains((Object)ManaSymbol.HYBRID_CW)) {
                chosenManaAbilityForHybrid = ability;
                countColored.add(ManaSymbol.HYBRID_CW);
            }
        }
        return chosenManaAbilityForHybrid;
    }

    private static ActivatedManaAbilityImpl checkGreenMana(ManaSymbols symbols, Set<ManaSymbol> countColored, ActivatedManaAbilityImpl ability) {
        ActivatedManaAbilityImpl chosenManaAbilityForHybrid = null;
        if (ability instanceof GreenManaAbility) {
            if (symbols.contains((Object)ManaSymbol.HYBRID_GW)) {
                chosenManaAbilityForHybrid = ability;
                countColored.add(ManaSymbol.HYBRID_GW);
            } else if (symbols.contains((Object)ManaSymbol.HYBRID_GU)) {
                chosenManaAbilityForHybrid = ability;
                countColored.add(ManaSymbol.HYBRID_GU);
            } else if (symbols.contains((Object)ManaSymbol.HYBRID_BG)) {
                chosenManaAbilityForHybrid = ability;
                countColored.add(ManaSymbol.HYBRID_BG);
            } else if (symbols.contains((Object)ManaSymbol.HYBRID_RG)) {
                chosenManaAbilityForHybrid = ability;
                countColored.add(ManaSymbol.HYBRID_RG);
            } else if (symbols.contains((Object)ManaSymbol.HYBRID_CG)) {
                chosenManaAbilityForHybrid = ability;
                countColored.add(ManaSymbol.HYBRID_CG);
            }
        }
        return chosenManaAbilityForHybrid;
    }

    private static Map<UUID, ActivatedManaAbilityImpl> getManaAbilitiesUsingMana(ManaCost unpaid, Map<UUID, ActivatedManaAbilityImpl> useableAbilities) {
        Mana mana = unpaid.getMana();
        int countColorfull = 0;
        boolean countColorless = false;
        ActivatedManaAbilityImpl chosenManaAbility = null;
        for (ActivatedManaAbilityImpl ability : useableAbilities.values()) {
            if (ability instanceof RedManaAbility && mana.contains(Mana.RedMana(1))) {
                chosenManaAbility = ability;
                ++countColorfull;
            }
            if (ability instanceof BlackManaAbility && mana.contains(Mana.BlackMana(1))) {
                chosenManaAbility = ability;
                ++countColorfull;
            }
            if (ability instanceof BlueManaAbility && mana.contains(Mana.BlueMana(1))) {
                chosenManaAbility = ability;
                ++countColorfull;
            }
            if (ability instanceof WhiteManaAbility && mana.contains(Mana.WhiteMana(1))) {
                chosenManaAbility = ability;
                ++countColorfull;
            }
            if (!(ability instanceof GreenManaAbility) || !mana.contains(Mana.GreenMana(1))) continue;
            chosenManaAbility = ability;
            ++countColorfull;
        }
        if (countColorfull == 0) {
            if (mana.getGeneric() > 0) {
                for (ActivatedManaAbilityImpl manaAbility : useableAbilities.values()) {
                    if (manaAbility.getCosts().size() != 1 || !((Cost)manaAbility.getCosts().get(0)).getClass().equals(TapSourceCost.class)) continue;
                    return ManaUtil.replace(useableAbilities, manaAbility);
                }
                return ManaUtil.replace(useableAbilities, useableAbilities.values().iterator().next());
            }
            return useableAbilities;
        }
        if (countColorfull > 1) {
            return useableAbilities;
        }
        return ManaUtil.replace(useableAbilities, chosenManaAbility);
    }

    private static Map<UUID, ActivatedManaAbilityImpl> replace(Map<UUID, ActivatedManaAbilityImpl> useableAbilities, ActivatedManaAbilityImpl chosenManaAbility) {
        useableAbilities.clear();
        useableAbilities.put(chosenManaAbility.getId(), chosenManaAbility);
        return useableAbilities;
    }

    public static String addSpecialManaPayAbilities(Ability source, Game game, ManaCost unpaid) {
        MageObject mageObject;
        MageObject baseObject = game.getPermanent(source.getSourceId());
        if (baseObject == null) {
            baseObject = game.getCard(source.getSourceId());
        }
        if ((mageObject = source.getSourceObject(game)) instanceof Card) {
            for (Ability ability : ((Card)mageObject).getAbilities(game)) {
                if (!(ability instanceof AlternateManaPaymentAbility)) continue;
                ((AlternateManaPaymentAbility)((Object)ability)).addSpecialAction(source, game, unpaid);
            }
            if (baseObject == null) {
                baseObject = mageObject;
            }
        }
        if (baseObject != null) {
            return unpaid.getText() + "<div style='font-size:11pt'>" + baseObject.getLogName() + "</div>";
        }
        return unpaid.getText();
    }

    public static String condenseManaCostString(String rawCost) {
        int total = 0;
        int index = 0;
        Object[] splitCost = rawCost.replace("{", "").replace("}", " ").split(" ");
        Arrays.sort(splitCost);
        for (Object c : splitCost) {
            if (!((String)c).matches("\\d+")) break;
            total += Integer.parseInt((String)c);
            ++index;
        }
        int splitCostLength = splitCost.length;
        int shift = total > 0 ? 1 : 0;
        String[] finalCost = new String[shift + splitCostLength - index];
        if (total > 0) {
            finalCost[0] = String.valueOf(total);
        }
        System.arraycopy(splitCost, index, finalCost, shift, splitCostLength - index);
        StringBuilder sb = new StringBuilder();
        for (String s : finalCost) {
            sb.append('{').append(s).append('}');
        }
        return sb.toString();
    }

    public static boolean isColorIdentityCompatible(FilterMana needColors, FilterMana cardColors) {
        return !(needColors == null || cardColors.isBlack() && !needColors.isBlack() || cardColors.isBlue() && !needColors.isBlue() || cardColors.isGreen() && !needColors.isGreen() || cardColors.isRed() && !needColors.isRed() || cardColors.isWhite() && !needColors.isWhite());
    }

    public static void collectColorIdentity(FilterMana destColors, FilterMana newColors) {
        if (newColors.isWhite()) {
            destColors.setWhite(true);
        }
        if (newColors.isBlue()) {
            destColors.setBlue(true);
        }
        if (newColors.isBlack()) {
            destColors.setBlack(true);
        }
        if (newColors.isRed()) {
            destColors.setRed(true);
        }
        if (newColors.isGreen()) {
            destColors.setGreen(true);
        }
    }

    public static FilterMana getColorIdentity(ObjectColor cardColor, String cardManaSymbols, List<String> cardRules, Card secondSideCard) {
        FilterMana res = new FilterMana();
        ObjectColor color = cardColor != null ? new ObjectColor(cardColor) : new ObjectColor();
        res.setWhite(color.isWhite() || ManaUtil.containsManaSymbol(cardManaSymbols, "W"));
        res.setBlue(color.isBlue() || ManaUtil.containsManaSymbol(cardManaSymbols, "U"));
        res.setBlack(color.isBlack() || ManaUtil.containsManaSymbol(cardManaSymbols, "B"));
        res.setRed(color.isRed() || ManaUtil.containsManaSymbol(cardManaSymbols, "R"));
        res.setGreen(color.isGreen() || ManaUtil.containsManaSymbol(cardManaSymbols, "G"));
        for (String rule : cardRules) {
            rule = rule.replaceAll("(?i)<i.*?</i>", "");
            if (!res.isWhite() && rule.matches(regexWhite)) {
                res.setWhite(true);
            }
            if (!res.isBlue() && rule.matches(regexBlue)) {
                res.setBlue(true);
            }
            if (!res.isBlack() && rule.matches(regexBlack)) {
                res.setBlack(true);
            }
            if (!res.isRed() && rule.matches(regexRed)) {
                res.setRed(true);
            }
            if (res.isGreen() || !rule.matches(regexGreen)) continue;
            res.setGreen(true);
        }
        if (secondSideCard != null) {
            ObjectColor secondColor = secondSideCard.getColor(null);
            res.setBlack(res.isBlack() || secondColor.isBlack());
            res.setGreen(res.isGreen() || secondColor.isGreen());
            res.setRed(res.isRed() || secondColor.isRed());
            res.setBlue(res.isBlue() || secondColor.isBlue());
            res.setWhite(res.isWhite() || secondColor.isWhite());
            List<String> secondManaSymbols = secondSideCard.getManaCostSymbols();
            res.setWhite(res.isWhite() || ManaUtil.containsManaSymbol(secondManaSymbols, "W"));
            res.setBlue(res.isBlue() || ManaUtil.containsManaSymbol(secondManaSymbols, "U"));
            res.setBlack(res.isBlack() || ManaUtil.containsManaSymbol(secondManaSymbols, "B"));
            res.setRed(res.isRed() || ManaUtil.containsManaSymbol(secondManaSymbols, "R"));
            res.setGreen(res.isGreen() || ManaUtil.containsManaSymbol(secondManaSymbols, "G"));
            for (String rule : secondSideCard.getRules()) {
                rule = rule.replaceAll("(?i)<i.*?</i>", "");
                if (!res.isWhite() && rule.matches(regexWhite)) {
                    res.setWhite(true);
                }
                if (!res.isBlue() && rule.matches(regexBlue)) {
                    res.setBlue(true);
                }
                if (!res.isBlack() && rule.matches(regexBlack)) {
                    res.setBlack(true);
                }
                if (!res.isRed() && rule.matches(regexRed)) {
                    res.setRed(true);
                }
                if (res.isGreen() || !rule.matches(regexGreen)) continue;
                res.setGreen(true);
            }
        }
        return res;
    }

    private static boolean containsManaSymbol(List<String> cardManaSymbols, String needSymbol) {
        return cardManaSymbols.stream().anyMatch(s -> s.contains(needSymbol));
    }

    private static boolean containsManaSymbol(String cardManaSymbols, String needSymbol) {
        return cardManaSymbols.contains(needSymbol);
    }

    public static FilterMana getColorIdentity(Card card) {
        Card secondSide = card instanceof SplitCard ? ((SplitCard)card).getRightHalfCard() : (card instanceof CardWithSpellOption ? ((CardWithSpellOption)card).getSpellCard() : (card instanceof ModalDoubleFacedCard ? ((ModalDoubleFacedCard)card).getRightHalfCard() : card.getSecondCardFace()));
        return ManaUtil.getColorIdentity(card.getColor(), String.join((CharSequence)"", card.getManaCostSymbols()), card.getRules(), secondSide);
    }

    public static FilterMana getColorIdentity(Token token) {
        return ManaUtil.getColorIdentity(token.getColor(), String.join((CharSequence)"", token.getManaCostSymbols()), token.getAbilities().getRules(), token.getBackFace() == null ? null : token.getBackFace().getCopySourceCard());
    }

    public static int getColorIdentityHash(FilterMana colorIdentity) {
        int hash = 3;
        hash = 23 * hash + (colorIdentity.isWhite() ? 1 : 0);
        hash = 23 * hash + (colorIdentity.isBlue() ? 1 : 0);
        hash = 23 * hash + (colorIdentity.isBlack() ? 1 : 0);
        hash = 23 * hash + (colorIdentity.isRed() ? 1 : 0);
        hash = 23 * hash + (colorIdentity.isGreen() ? 1 : 0);
        return hash;
    }

    public static ManaCost createManaCost(int genericManaCount, boolean payAsX) {
        if (payAsX) {
            VariableManaCost xCost = new VariableManaCost(VariableCostType.NORMAL);
            xCost.setAmount(genericManaCount, genericManaCount, false);
            return xCost;
        }
        return new GenericManaCost(genericManaCount);
    }

    public static ManaCost createManaCost(DynamicValue genericManaCount, Game game, Ability sourceAbility, Effect effect) {
        int costValue = genericManaCount.calculate(game, sourceAbility, effect);
        if (genericManaCount instanceof GetXValue) {
            return ManaUtil.createManaCost(costValue, true);
        }
        return ManaUtil.createManaCost(costValue, false);
    }

    public static int playerPaysXGenericMana(boolean payAsX, String restoreContextName, Player player, Ability source, Game game) {
        return ManaUtil.playerPaysXGenericMana(payAsX, restoreContextName, player, source, game, Integer.MAX_VALUE);
    }

    public static int playerPaysXGenericMana(boolean payAsX, String restoreContextName, Player player, Ability source, Game game, int maxValue) {
        int wantToPay = 0;
        boolean payed = false;
        if (player.canRespond()) {
            int bookmark = game.bookmarkState();
            player.resetStoredBookmark(game);
            wantToPay = player.announceX(0, maxValue, "Choose how much mana to pay", game, source, true);
            if (wantToPay > 0) {
                ManaCost cost = ManaUtil.createManaCost(wantToPay, payAsX);
                payed = cost.pay(source, game, source, player.getId(), false, null);
            } else {
                payed = true;
            }
            if (!payed) {
                player.restoreState(bookmark, restoreContextName, game);
                game.fireUpdatePlayersEvent();
            } else {
                game.removeBookmark(bookmark);
            }
        }
        if (payed) {
            game.informPlayers(player.getLogName() + " pays {" + wantToPay + "}.");
            return wantToPay;
        }
        return 0;
    }

    public static List<ManaType> getManaTypesInCost(ManaCost cost) {
        ArrayList<ManaType> res = new ArrayList<ManaType>();
        for (Mana mana : cost.getManaOptions()) {
            if (mana.getWhite() > 0) {
                res.add(ManaType.WHITE);
            }
            if (mana.getBlue() > 0) {
                res.add(ManaType.BLUE);
            }
            if (mana.getBlack() > 0) {
                res.add(ManaType.BLACK);
            }
            if (mana.getRed() > 0) {
                res.add(ManaType.RED);
            }
            if (mana.getGreen() > 0) {
                res.add(ManaType.GREEN);
            }
            if (mana.getColorless() <= 0 && mana.getGeneric() <= 0 && mana.getAny() <= 0) continue;
            res.add(ManaType.COLORLESS);
        }
        return res;
    }
}

