/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

public class AttackedLastTurnWatcher
extends Watcher {
    public final Map<UUID, Set<MageObjectReference>> attackedLastTurnCreatures = new HashMap<UUID, Set<MageObjectReference>>();
    public final Map<UUID, Set<MageObjectReference>> attackedThisTurnCreatures = new HashMap<UUID, Set<MageObjectReference>>();

    public AttackedLastTurnWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.BEGINNING_PHASE_PRE) {
            UUID activePlayer = game.getActivePlayerId();
            if (this.attackedThisTurnCreatures.containsKey(activePlayer)) {
                if (this.attackedThisTurnCreatures.get(activePlayer) != null) {
                    this.attackedLastTurnCreatures.put(activePlayer, this.getAttackedThisTurnCreatures(activePlayer));
                }
                this.attackedThisTurnCreatures.remove(activePlayer);
            } else {
                this.attackedLastTurnCreatures.remove(activePlayer);
            }
        }
        if (event.getType() == GameEvent.EventType.DECLARED_ATTACKERS) {
            UUID attackingPlayer = game.getCombat().getAttackingPlayerId();
            Set<MageObjectReference> attackingCreatures = this.getAttackedThisTurnCreatures(attackingPlayer);
            for (UUID attackerId : game.getCombat().getAttackers()) {
                Permanent attacker = game.getPermanent(attackerId);
                if (attacker == null) continue;
                attackingCreatures.add(new MageObjectReference(attacker, game));
            }
            this.attackedThisTurnCreatures.put(attackingPlayer, attackingCreatures);
        }
    }

    public Set<MageObjectReference> getAttackedLastTurnCreatures(UUID combatPlayerId) {
        if (this.attackedLastTurnCreatures.get(combatPlayerId) != null) {
            return this.attackedLastTurnCreatures.get(combatPlayerId);
        }
        return new HashSet<MageObjectReference>();
    }

    public Set<MageObjectReference> getAttackedThisTurnCreatures(UUID combatPlayerId) {
        if (this.attackedThisTurnCreatures.get(combatPlayerId) != null) {
            return this.attackedThisTurnCreatures.get(combatPlayerId);
        }
        return new HashSet<MageObjectReference>();
    }
}

