/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageObjectReference;
import mage.cards.Card;
import mage.constants.WatcherScope;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.watchers.Watcher;

public class CardsPutIntoGraveyardWatcher
extends Watcher {
    private final Map<UUID, Integer> amountOfCardsThisTurn = new HashMap<UUID, Integer>();
    private final Set<MageObjectReference> cardsPutIntoGraveyardFromBattlefield = new HashSet<MageObjectReference>();
    private final Set<MageObjectReference> cardsPutIntoGraveyardFromEverywhereElse = new HashSet<MageObjectReference>();

    public CardsPutIntoGraveyardWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.ZONE_CHANGE || ((ZoneChangeEvent)event).getToZone() != Zone.GRAVEYARD) {
            return;
        }
        UUID playerId = event.getPlayerId();
        Card card = game.getCard(event.getTargetId());
        if (playerId == null || card == null) {
            return;
        }
        this.amountOfCardsThisTurn.compute(playerId, (k, amount) -> amount == null ? 1 : Integer.sum(amount, 1));
        if (((ZoneChangeEvent)event).getFromZone() == Zone.BATTLEFIELD) {
            this.cardsPutIntoGraveyardFromBattlefield.add(new MageObjectReference(((ZoneChangeEvent)event).getTarget(), game, 1));
        } else {
            this.cardsPutIntoGraveyardFromEverywhereElse.add(new MageObjectReference(game.getCard(event.getTargetId()), game, 0));
        }
    }

    public int getAmountCardsPutToGraveyard(UUID playerId) {
        return this.amountOfCardsThisTurn.getOrDefault(playerId, 0);
    }

    public Set<Card> getCardsPutIntoGraveyardFromBattlefield(Game game) {
        return this.cardsPutIntoGraveyardFromBattlefield.stream().map(mor -> mor.getCard(game)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public Set<Card> getCardsPutIntoGraveyardNotFromBattlefield(Game game) {
        return this.cardsPutIntoGraveyardFromEverywhereElse.stream().map(mor -> mor.getCard(game)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public Set<Card> getCardsPutIntoGraveyardFromAnywhere(Game game) {
        Set<Card> cardsPutIntoGraveyardFromAnywhere = this.getCardsPutIntoGraveyardFromBattlefield(game);
        cardsPutIntoGraveyardFromAnywhere.addAll(this.getCardsPutIntoGraveyardNotFromBattlefield(game));
        return cardsPutIntoGraveyardFromAnywhere;
    }

    public boolean checkCardFromBattlefield(Card card, Game game) {
        return this.cardsPutIntoGraveyardFromBattlefield.stream().anyMatch(mor -> mor.refersTo(card, game));
    }

    public boolean checkCardNotFromBattlefield(Card card, Game game) {
        return this.cardsPutIntoGraveyardFromEverywhereElse.stream().anyMatch(mor -> mor.refersTo(card, game));
    }

    public boolean checkCardFromAnywhere(Card card, Game game) {
        return this.checkCardFromBattlefield(card, game) || this.checkCardNotFromBattlefield(card, game);
    }

    @Override
    public void reset() {
        super.reset();
        this.amountOfCardsThisTurn.clear();
        this.cardsPutIntoGraveyardFromBattlefield.clear();
        this.cardsPutIntoGraveyardFromEverywhereElse.clear();
    }
}

