/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

public class DamageDoneWatcher
extends Watcher {
    private final Map<MageObjectReference, Integer> damagingObjects = new HashMap<MageObjectReference, Integer>();
    private final Map<MageObjectReference, Integer> damagedObjects = new HashMap<MageObjectReference, Integer>();
    private final Map<MageObjectReference, Integer> objectsToPlayersDamaged = new HashMap<MageObjectReference, Integer>();

    public Map<MageObjectReference, Integer> getDamagingObjects() {
        return this.damagingObjects;
    }

    public Map<MageObjectReference, Integer> getDamagedObjects() {
        return this.damagedObjects;
    }

    public DamageDoneWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        switch (event.getType()) {
            case DAMAGED_PERMANENT: 
            case DAMAGED_PLAYER: {
                MageObjectReference damageSourceRef = new MageObjectReference(event.getSourceId(), game);
                this.damagingObjects.putIfAbsent(damageSourceRef, 0);
                this.damagingObjects.compute(damageSourceRef, (k, damage) -> damage + event.getAmount());
                MageObjectReference damageTargetRef = new MageObjectReference(event.getTargetId(), game);
                this.damagedObjects.putIfAbsent(damageTargetRef, 0);
                this.damagedObjects.compute(damageTargetRef, (k, damage) -> damage + event.getAmount());
                if (game.getPlayer(event.getTargetId()) == null) break;
                this.objectsToPlayersDamaged.putIfAbsent(damageSourceRef, 0);
                this.objectsToPlayersDamaged.compute(damageSourceRef, (k, numPlayers) -> numPlayers + 1);
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.damagingObjects.clear();
        this.damagedObjects.clear();
        this.objectsToPlayersDamaged.clear();
    }

    public int damageDoneBy(UUID objectId, int zoneChangeCounter, Game game) {
        MageObjectReference mor = new MageObjectReference(objectId, zoneChangeCounter, game);
        return this.damagingObjects.getOrDefault(mor, 0);
    }

    public int damageDoneTo(UUID objectId, int zoneChangeCounter, Game game) {
        MageObjectReference mor = new MageObjectReference(objectId, zoneChangeCounter, game);
        return this.damagedObjects.getOrDefault(mor, 0);
    }

    public boolean isDamaged(UUID objectId, int zoneChangeCounter, Game game) {
        MageObjectReference mor = new MageObjectReference(objectId, zoneChangeCounter, game);
        return this.damagedObjects.containsKey(mor);
    }

    public boolean damagedAPlayer(UUID objectId, int zoneChangeCounter, Game game) {
        MageObjectReference mor = new MageObjectReference(objectId, zoneChangeCounter, game);
        return this.objectsToPlayersDamaged.containsKey(mor);
    }
}

