/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.HashSet;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

public class DamagedByControlledWatcher
extends Watcher {
    private final HashSet<MageObjectReference> damagedPermanents = new HashSet();

    public DamagedByControlledWatcher() {
        super(WatcherScope.PLAYER);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        Permanent permanent;
        if (event.getType() == GameEvent.EventType.DAMAGED_PERMANENT && (permanent = game.getPermanent(event.getTargetId())) != null && permanent.isCreature(game) && this.controllerId != null && this.controllerId.equals(game.getControllerId(event.getSourceId()))) {
            this.damagedPermanents.add(new MageObjectReference(event.getTargetId(), game));
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.damagedPermanents.clear();
    }

    public boolean wasDamaged(Permanent permanent, Game game) {
        return this.damagedPermanents.contains(new MageObjectReference(permanent, game));
    }
}

