/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

public class DamagedByWatcher
extends Watcher {
    private final Set<MageObjectReference> damagedBySource = new HashSet<MageObjectReference>();
    private final boolean watchPlaneswalkers;

    public DamagedByWatcher(boolean watchPlaneswalkers) {
        super(WatcherScope.CARD);
        this.watchPlaneswalkers = watchPlaneswalkers;
    }

    @Override
    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.DAMAGED_PERMANENT) {
            return;
        }
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (permanent != null && !this.watchPlaneswalkers && !permanent.isCreature(game)) {
            return;
        }
        if (this.sourceId.equals(event.getSourceId())) {
            this.damagedBySource.add(new MageObjectReference(event.getTargetId(), game));
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.damagedBySource.clear();
    }

    public boolean wasDamaged(UUID sourceId, Game game) {
        MageObject mageObject = game.getObject(sourceId);
        if (mageObject instanceof Permanent) {
            return this.wasDamaged((Permanent)mageObject, game);
        }
        return false;
    }

    public boolean wasDamaged(Permanent permanent, Game game) {
        return this.damagedBySource.contains(new MageObjectReference(permanent, game));
    }
}

