/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

public class FirstStrikeWatcher
extends Watcher {
    private final Set<MageObjectReference> firstStrikingCreatures = new HashSet<MageObjectReference>();

    public FirstStrikeWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.COMBAT_PHASE_POST) {
            this.firstStrikingCreatures.clear();
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.firstStrikingCreatures.clear();
    }

    public static void recordFirstStrikingCreature(UUID creatureId, Game game) {
        game.getState().getWatcher(FirstStrikeWatcher.class).firstStrikingCreatures.add(new MageObjectReference(creatureId, game));
    }

    public static boolean wasFirstStrikingCreature(UUID creatureId, Game game) {
        return game.getState().getWatcher(FirstStrikeWatcher.class).firstStrikingCreatures.contains(new MageObjectReference(creatureId, game));
    }
}

