/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.watchers.Watcher;

public class LifeLossOtherFromCombatWatcher
extends Watcher {
    private final Set<UUID> players = new HashSet<UUID>();

    public LifeLossOtherFromCombatWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        UUID playerId;
        if (event.getType() == GameEvent.EventType.LOST_LIFE && !event.getFlag() && (playerId = event.getPlayerId()) != null) {
            this.players.add(playerId);
        }
    }

    public boolean opponentLostLifeOtherFromCombat(UUID playerId, Game game) {
        Player player = game.getPlayer(playerId);
        return player != null && this.players.stream().anyMatch(damagedPlayerId -> player.hasOpponent((UUID)damagedPlayerId, game));
    }

    @Override
    public void reset() {
        super.reset();
        this.players.clear();
    }
}

