/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

public class PermanentsEnteredBattlefieldWatcher
extends Watcher {
    private final Map<UUID, List<Permanent>> enteringBattlefield = new HashMap<UUID, List<Permanent>>();
    private final Map<UUID, List<Permanent>> enteringBattlefieldLastTurn = new HashMap<UUID, List<Permanent>>();

    public PermanentsEnteredBattlefieldWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD) {
            Permanent perm = game.getPermanentEntering(event.getTargetId());
            if (perm == null) {
                perm = game.getPermanent(event.getTargetId());
            }
            if (perm != null) {
                List<Object> permanents;
                if (!this.enteringBattlefield.containsKey(perm.getControllerId())) {
                    permanents = new ArrayList();
                    this.enteringBattlefield.put(perm.getControllerId(), permanents);
                } else {
                    permanents = this.enteringBattlefield.get(perm.getControllerId());
                }
                permanents.add(perm.copy());
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.enteringBattlefieldLastTurn.clear();
        this.enteringBattlefieldLastTurn.putAll(this.enteringBattlefield);
        this.enteringBattlefield.clear();
    }

    public List<Permanent> getThisTurnEnteringPermanents(UUID playerId) {
        return this.enteringBattlefield.getOrDefault(playerId, Collections.emptyList());
    }

    public boolean anotherCreatureEnteredBattlefieldUnderPlayersControlLastTurn(Permanent sourcePermanent, Game game) {
        if (this.enteringBattlefieldLastTurn.containsKey(sourcePermanent.getControllerId())) {
            for (Permanent permanent : this.enteringBattlefieldLastTurn.get(sourcePermanent.getControllerId())) {
                if (permanent.getId().equals(sourcePermanent.getId()) || !permanent.isCreature(game)) continue;
                return true;
            }
        }
        return false;
    }
}

