/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

public class PlayLandWatcher
extends Watcher {
    private final Set<UUID> playerPlayedLand = new HashSet<UUID>();
    private final Set<MageObjectReference> landPlayed = new HashSet<MageObjectReference>();

    public PlayLandWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        Permanent permanent;
        if (event.getType() == GameEvent.EventType.LAND_PLAYED && (permanent = game.getPermanentOrLKIBattlefield(event.getTargetId())) != null && permanent.isLand(game)) {
            MageObjectReference mor = new MageObjectReference(permanent, game);
            this.landPlayed.add(mor);
            this.playerPlayedLand.add(event.getPlayerId());
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.playerPlayedLand.clear();
        this.landPlayed.clear();
    }

    public boolean landPlayed(UUID playerId) {
        return this.playerPlayedLand.contains(playerId);
    }

    public boolean wasLandPlayed(Permanent land, Game game) {
        return this.landPlayed.contains(new MageObjectReference(land, game));
    }
}

