/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

public class PlayerGainedLifeWatcher
extends Watcher {
    private final Map<UUID, Integer> amountOfLifeGainedThisTurn = new HashMap<UUID, Integer>();

    public PlayerGainedLifeWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        UUID playerId;
        if (event.getType() == GameEvent.EventType.UNTAP_STEP_PRE) {
            this.reset();
        }
        if (event.getType() == GameEvent.EventType.GAINED_LIFE && (playerId = event.getPlayerId()) != null) {
            this.amountOfLifeGainedThisTurn.putIfAbsent(playerId, 0);
            this.amountOfLifeGainedThisTurn.compute(playerId, (p, amount) -> amount + event.getAmount());
        }
    }

    public int getLifeGained(UUID playerId) {
        return this.amountOfLifeGainedThisTurn.getOrDefault(playerId, 0);
    }

    @Override
    public void reset() {
        super.reset();
        this.amountOfLifeGainedThisTurn.clear();
    }
}

