/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.watchers.Watcher;

public class PlayerLostLifeWatcher
extends Watcher {
    private final Map<UUID, Integer> amountOfLifeLostThisTurn = new HashMap<UUID, Integer>();
    private final Map<UUID, Integer> amountOfLifeLostLastTurn = new HashMap<UUID, Integer>();

    public PlayerLostLifeWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        UUID playerId;
        if (event.getType() == GameEvent.EventType.LOST_LIFE && (playerId = event.getPlayerId()) != null) {
            Integer amount = this.amountOfLifeLostThisTurn.get(playerId);
            amount = amount == null ? Integer.valueOf(event.getAmount()) : Integer.valueOf(amount + event.getAmount());
            this.amountOfLifeLostThisTurn.put(playerId, amount);
        }
    }

    public int getLifeLost(UUID playerId) {
        return this.amountOfLifeLostThisTurn.getOrDefault(playerId, 0);
    }

    public int getAllOppLifeLost(UUID playerId, Game game) {
        int amount = 0;
        for (UUID opponentId : this.amountOfLifeLostThisTurn.keySet()) {
            Player opponent = game.getPlayer(opponentId);
            if (opponent == null || !opponent.hasOpponent(playerId, game)) continue;
            amount += this.amountOfLifeLostThisTurn.getOrDefault(opponentId, 0).intValue();
        }
        return amount;
    }

    public int getNumberOfOpponentsWhoLostLife(UUID playerId, Game game) {
        int numPlayersLostLife = 0;
        for (UUID opponentId : this.amountOfLifeLostThisTurn.keySet()) {
            Player opponent = game.getPlayer(opponentId);
            if (opponent == null || !opponent.hasOpponent(playerId, game) || this.amountOfLifeLostThisTurn.getOrDefault(opponentId, 0) <= 0) continue;
            ++numPlayersLostLife;
        }
        return numPlayersLostLife;
    }

    public int getLifeLostLastTurn(UUID playerId) {
        return this.amountOfLifeLostLastTurn.getOrDefault(playerId, 0);
    }

    @Override
    public void reset() {
        super.reset();
        this.amountOfLifeLostLastTurn.clear();
        this.amountOfLifeLostLastTurn.putAll(this.amountOfLifeLostThisTurn);
        this.amountOfLifeLostThisTurn.clear();
    }
}

