/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.PlayerList;
import mage.watchers.Watcher;

public class PlayersAttackedThisTurnWatcher
extends Watcher {
    private final Map<UUID, PlayerList> playersAttackedThisTurn = new HashMap<UUID, PlayerList>();
    private final Map<UUID, PlayerList> opponentsAttackedThisTurn = new HashMap<UUID, PlayerList>();
    private final Map<UUID, PlayerList> planeswalkerControllerAttackedThisTurn = new HashMap<UUID, PlayerList>();

    public PlayersAttackedThisTurnWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.ATTACKER_DECLARED) {
            UUID opponentDefender;
            UUID playerDefender;
            PlayerList playersAttacked = this.playersAttackedThisTurn.get(event.getPlayerId());
            if (playersAttacked == null) {
                playersAttacked = new PlayerList();
            }
            if ((playerDefender = event.getTargetId()) != null && game.getPlayer(playerDefender) != null && !playersAttacked.contains(playerDefender)) {
                playersAttacked.add(playerDefender);
            }
            this.playersAttackedThisTurn.putIfAbsent(event.getPlayerId(), playersAttacked);
            PlayerList opponentsAttacked = this.opponentsAttackedThisTurn.get(event.getPlayerId());
            if (opponentsAttacked == null) {
                opponentsAttacked = new PlayerList();
            }
            if ((opponentDefender = event.getTargetId()) != null && game.getOpponents(event.getPlayerId()).contains(opponentDefender) && !opponentsAttacked.contains(opponentDefender)) {
                opponentsAttacked.add(opponentDefender);
            }
            this.opponentsAttackedThisTurn.putIfAbsent(event.getPlayerId(), opponentsAttacked);
            PlayerList controllersAttacked = this.planeswalkerControllerAttackedThisTurn.get(event.getPlayerId());
            if (controllersAttacked == null) {
                controllersAttacked = new PlayerList();
            }
            Permanent permanent = game.getPermanent(event.getTargetId());
            UUID controllingDefender = game.getCombat().getDefendingPlayerId(event.getSourceId(), game);
            if (controllingDefender != null && permanent != null && permanent.isPlaneswalker(game) && !controllersAttacked.contains(controllingDefender)) {
                controllersAttacked.add(controllingDefender);
            }
            this.planeswalkerControllerAttackedThisTurn.putIfAbsent(event.getPlayerId(), controllersAttacked);
        }
    }

    public boolean hasPlayerAttackedPlayer(UUID attacker, UUID defender) {
        PlayerList defendersList = this.playersAttackedThisTurn.getOrDefault(attacker, null);
        return defendersList != null && defendersList.contains(defender);
    }

    public boolean hasPlayerAttackedPlayerOrControlledPlaneswalker(UUID attacker, UUID defender) {
        PlayerList defendersList = this.playersAttackedThisTurn.getOrDefault(attacker, null);
        PlayerList planeswalkerControllersList = this.planeswalkerControllerAttackedThisTurn.getOrDefault(attacker, null);
        return defendersList != null && defendersList.contains(defender) || planeswalkerControllersList != null && planeswalkerControllersList.contains(defender);
    }

    public int getAttackedPlayersCount(UUID playerID) {
        PlayerList defendersList = this.playersAttackedThisTurn.getOrDefault(playerID, null);
        if (defendersList != null) {
            return defendersList.size();
        }
        return 0;
    }

    public int getAttackedOpponentsCount(UUID playerID) {
        PlayerList defendersList = this.opponentsAttackedThisTurn.getOrDefault(playerID, null);
        if (defendersList != null) {
            return defendersList.size();
        }
        return 0;
    }

    @Override
    public void reset() {
        super.reset();
        this.playersAttackedThisTurn.clear();
        this.opponentsAttackedThisTurn.clear();
        this.planeswalkerControllerAttackedThisTurn.clear();
    }
}

