/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

public class RevoltWatcher
extends Watcher {
    private final Set<UUID> revoltActivePlayerIds = new HashSet<UUID>();

    public RevoltWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        Permanent permanent;
        ZoneChangeEvent zEvent;
        if (event.getType() == GameEvent.EventType.ZONE_CHANGE && event instanceof ZoneChangeEvent && (zEvent = (ZoneChangeEvent)event).getFromZone() == Zone.BATTLEFIELD && (permanent = zEvent.getTarget()) != null) {
            this.revoltActivePlayerIds.add(permanent.getControllerId());
        }
    }

    public boolean revoltActive(UUID playerId) {
        return this.revoltActivePlayerIds.contains(playerId);
    }

    public static boolean checkAny(Game game) {
        return !game.getState().getWatcher(RevoltWatcher.class).revoltActivePlayerIds.isEmpty();
    }

    @Override
    public void reset() {
        super.reset();
        this.revoltActivePlayerIds.clear();
    }
}

