/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

public class SaddledMountWatcher
extends Watcher {
    private final Map<MageObjectReference, Set<MageObjectReference>> saddleMap = new HashMap<MageObjectReference, Set<MageObjectReference>>();
    private final Set<MageObjectReference> saddledSet = new HashSet<MageObjectReference>();

    public SaddledMountWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        switch (event.getType()) {
            case SADDLED_MOUNT: {
                this.saddleMap.computeIfAbsent(new MageObjectReference(event.getSourceId(), game), x -> new HashSet()).add(new MageObjectReference(event.getTargetId(), game));
                break;
            }
            case MOUNT_SADDLED: {
                this.saddledSet.add(new MageObjectReference(event.getSourceId(), game));
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.saddleMap.clear();
        this.saddledSet.clear();
    }

    public static boolean hasBeenSaddledThisTurn(MageObjectReference mountMOR, Game game) {
        SaddledMountWatcher watcher = game.getState().getWatcher(SaddledMountWatcher.class);
        return watcher != null && watcher.saddledSet.contains(mountMOR);
    }

    public static boolean checkIfSaddledThisTurn(Permanent saddler, MageObjectReference mountMOR, Game game) {
        return SaddledMountWatcher.hasBeenSaddledThisTurn(mountMOR, game) && game.getState().getWatcher(SaddledMountWatcher.class).saddleMap.getOrDefault(mountMOR, Collections.emptySet()).stream().anyMatch(mor -> mor.refersTo(saddler, game));
    }
}

