/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.util.CardUtil;
import mage.watchers.Watcher;

public class TemptedByTheRingWatcher
extends Watcher {
    private final Map<UUID, Integer> map = new HashMap<UUID, Integer>();

    public TemptedByTheRingWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        switch (event.getType()) {
            case TEMPTED_BY_RING: {
                this.map.compute(event.getPlayerId(), CardUtil::setOrIncrementValue);
                return;
            }
            case BEGINNING_PHASE_PRE: {
                if (game.getTurnNum() != 1) break;
                this.map.clear();
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
    }

    public static int getCount(UUID playerId, Game game) {
        return game.getState().getWatcher(TemptedByTheRingWatcher.class).map.getOrDefault(playerId, 0);
    }
}

