/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import mage.MageObject;
import mage.constants.SubType;
import mage.constants.WatcherScope;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.watchers.Watcher;

public class ZuberasDiedWatcher
extends Watcher {
    private int zuberasDiedThisTurn = 0;

    public int getZuberasDiedThisTurn() {
        return this.zuberasDiedThisTurn;
    }

    public ZuberasDiedWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        MageObject card;
        if (event.getType() == GameEvent.EventType.ZONE_CHANGE && ((ZoneChangeEvent)event).isDiesEvent() && (card = game.getLastKnownInformation(event.getTargetId(), Zone.BATTLEFIELD)) != null && card.hasSubtype(SubType.ZUBERA, game)) {
            ++this.zuberasDiedThisTurn;
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.zuberasDiedThisTurn = 0;
    }
}

