/*
 * Decompiled with CFR 0.152.
 */
package mage.game;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.InfoEffect;
import mage.cards.repository.CardInfo;
import mage.cards.repository.CardRepository;
import mage.constants.MultiplayerAttackOption;
import mage.constants.PhaseStep;
import mage.constants.RangeOfInfluence;
import mage.constants.Zone;
import mage.game.GameImpl;
import mage.game.MomirFreeForAllType;
import mage.game.command.Emblem;
import mage.game.command.emblems.MomirEmblem;
import mage.game.match.MatchType;
import mage.game.mulligan.Mulligan;
import mage.game.turn.TurnMod;
import mage.players.Player;

public class MomirGame
extends GameImpl {
    private int numPlayers;

    public MomirGame(MultiplayerAttackOption attackOption, RangeOfInfluence range, Mulligan mulligan, int startLife, int startHandSize) {
        super(attackOption, range, mulligan, 60, startLife, startHandSize);
    }

    public MomirGame(MomirGame game) {
        super((GameImpl)game);
    }

    public MatchType getGameType() {
        return new MomirFreeForAllType();
    }

    public int getNumPlayers() {
        return this.numPlayers;
    }

    protected void init(UUID choosingPlayerId) {
        SimpleStaticAbility ability = new SimpleStaticAbility(Zone.COMMAND, (Effect)new InfoEffect("Vanguard effects"));
        for (UUID playerId : this.state.getPlayerList(this.startingPlayerId)) {
            Player player = this.getPlayer(playerId);
            if (player == null) continue;
            CardInfo cardInfo = CardRepository.instance.findCardWithPreferredSetAndNumber("Momir Vig, Simic Visionary", "DIS", "118");
            if (cardInfo == null) {
                throw new IllegalStateException("Wrong code usage: momir card and emblem must exists in the same set (DIS)");
            }
            this.addEmblem((Emblem)new MomirEmblem(), (MageObject)cardInfo.createCard(), playerId);
        }
        this.getState().addAbility((Ability)ability, null);
        super.init(choosingPlayerId);
        this.state.getTurnMods().add(new TurnMod(this.startingPlayerId).withSkipStep(PhaseStep.DRAW));
    }

    public MomirGame copy() {
        return new MomirGame(this);
    }
}

