/*
 * Decompiled with CFR 0.152.
 */
package mage.cards;

import java.awt.Graphics2D;

public class MageCardAnimationSettings {
    private boolean visible = true;
    private double translateX = 0.0;
    private double translateY = 0.0;
    private double scaleX = 0.0;
    private double scaleY = 0.0;
    private double rotateTheta = 0.0;
    private double rotateX = 0.0;
    private double rotateY = 0.0;

    public MageCardAnimationSettings withVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    public MageCardAnimationSettings withTranslate(double x, double y) {
        this.translateX = x;
        this.translateY = y;
        return this;
    }

    public MageCardAnimationSettings withScale(double x, double y) {
        this.scaleX = x;
        this.scaleY = y;
        return this;
    }

    public MageCardAnimationSettings withRotate(double rotateTheta, double x, double y) {
        this.rotateTheta = rotateTheta;
        this.rotateX = x;
        this.rotateY = y;
        return this;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void applyOffsets(int offsetX, int offsetY) {
        if (this.translateX != 0.0 || this.translateY != 0.0) {
            this.translateX += (double)offsetX;
            this.translateY += (double)offsetY;
        }
        if (this.rotateTheta != 0.0 || this.rotateX != 0.0 || this.rotateY != 0.0) {
            this.rotateX += (double)offsetX;
            this.rotateY += (double)offsetY;
        }
    }

    public void doTransforms(Graphics2D g2d) {
        if (!this.visible) {
            return;
        }
        double factorX = 1.0;
        double factorY = 1.0;
        if (this.translateX != 0.0 || this.translateY != 0.0) {
            g2d.translate(this.translateX * factorX, this.translateY * factorY);
        }
        if (this.scaleX != 0.0 || this.scaleY != 0.0) {
            g2d.scale(this.scaleX * factorX, this.scaleY * factorY);
        }
        if (this.rotateTheta != 0.0 || this.rotateX != 0.0 || this.rotateY != 0.0) {
            g2d.rotate(this.rotateTheta, this.rotateX * factorX, this.rotateY * factorY);
        }
    }
}

