/*
 * Decompiled with CFR 0.152.
 */
package mage.remote;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

public class ActionData {
    @Expose
    public UUID gameId;
    @Expose
    public String sessionId;
    @Expose
    public String type;
    @Expose
    public Object value;
    @Expose
    public String message;

    public String toJson() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.setExclusionStrategies(new ExclusionStrategy[]{new CustomExclusionStrategy()}).create();
        return gson.toJson((Object)this);
    }

    public ActionData(String type, UUID gameId, String sessionId) {
        this.type = type;
        this.sessionId = sessionId;
        this.gameId = gameId;
    }

    public ActionData(String type, UUID gameId) {
        this.type = type;
        this.gameId = gameId;
    }

    static class CustomExclusionStrategy
    implements ExclusionStrategy {
        private final Set<String> KEEP = new HashSet<String>(Arrays.asList("id", "choice", "damage", "abilityType", "ability", "abilities", "method", "data", "options", "life", "players", "zone", "step", "phase", "attackers", "blockers", "tapped", "damage", "combat", "paid", "hand", "stack", "manaValue", "gameId", "canPlayInHand", "gameView", "sessionId", "power", "choices", "targets", "loyalty", "toughness", "power", "type", "priorityTime", "manaCost", "value", "message", "cardsView", "name", "count", "counters", "battlefield", "parentId"));

        public boolean shouldSkipField(FieldAttributes f) {
            String name = f.getName();
            return !this.KEEP.contains(name);
        }

        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }
    }
}

