/*
 * Decompiled with CFR 0.152.
 */
package mage.utils.testers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mage.abilities.Ability;
import mage.choices.Choice;
import mage.choices.ChoiceBasicLandType;
import mage.choices.ChoiceCardType;
import mage.choices.ChoiceColor;
import mage.choices.ChoiceColorOrArtifact;
import mage.choices.ChoiceCreatureType;
import mage.choices.ChoiceLandType;
import mage.choices.ChoiceLeftOrRight;
import mage.choices.ChoicePlaneswalkerType;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.DebugUtil;
import mage.utils.testers.BaseTestableDialog;
import mage.utils.testers.ChoiceTestableResult;
import mage.utils.testers.TestableDialogsRunner;

class ChooseChoiceTestableDialog
extends BaseTestableDialog {
    boolean isYou;
    Choice choice;

    public ChooseChoiceTestableDialog(boolean isYou, String name, Choice choice) {
        super(String.format("player.choose(%s, choice)", isYou ? "you" : "AI"), name, choice.getClass().getSimpleName(), new ChoiceTestableResult());
        this.isYou = isYou;
        this.choice = choice;
    }

    @Override
    public void showDialog(Player player, Ability source, Game game, Player opponent) {
        String choice;
        Player choosingPlayer = this.isYou ? player : opponent;
        Choice dialog = (Choice)this.choice.copy();
        String chooseDebugSource = DebugUtil.getMethodNameWithSource((int)0, (String)"class");
        boolean chooseRes = choosingPlayer.choose(Outcome.Benefit, dialog, game);
        ArrayList<String> res = new ArrayList<String>();
        res.add(this.getGroup() + " - " + this.getName() + " - " + (chooseRes ? "TRUE" : "FALSE"));
        res.add("");
        if (dialog.isKeyChoice()) {
            String key = dialog.getChoiceKey();
            choice = dialog.getKeyChoices().getOrDefault(key, null);
            res.add(String.format("* selected key: %s (%s)", key, choice));
        } else {
            choice = dialog.getChoice();
            res.add(String.format("* selected value: %s", choice));
        }
        ((ChoiceTestableResult)this.getResult()).onFinish(chooseDebugSource, chooseRes, res, choice);
    }

    public static void register(TestableDialogsRunner runner) {
        List<Boolean> isYous = Arrays.asList(false, true);
        for (boolean isYou : isYous) {
            runner.registerDialog(new ChooseChoiceTestableDialog(isYou, "", (Choice)new ChoiceBasicLandType()));
            runner.registerDialog(new ChooseChoiceTestableDialog(isYou, "", (Choice)new ChoiceCardType()));
            runner.registerDialog(new ChooseChoiceTestableDialog(isYou, "", (Choice)new ChoiceColor()));
            runner.registerDialog(new ChooseChoiceTestableDialog(isYou, "", (Choice)new ChoiceColorOrArtifact()));
            runner.registerDialog(new ChooseChoiceTestableDialog(isYou, "", (Choice)new ChoiceCreatureType(null, null)));
            runner.registerDialog(new ChooseChoiceTestableDialog(isYou, "", (Choice)new ChoiceLandType()));
            runner.registerDialog(new ChooseChoiceTestableDialog(isYou, "", (Choice)new ChoiceLeftOrRight()));
            runner.registerDialog(new ChooseChoiceTestableDialog(isYou, "", (Choice)new ChoicePlaneswalkerType()));
        }
    }
}

