/*
 * Decompiled with CFR 0.152.
 */
package mage.view;

import java.io.Serializable;
import java.util.UUID;
import mage.game.Game;
import mage.game.combat.CombatGroup;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.view.CardsView;
import mage.view.PermanentView;

public class CombatGroupView
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final CardsView attackers = new CardsView();
    private final CardsView blockers = new CardsView();
    private final boolean isBlocked;
    private String defenderName = "";
    private final UUID defenderId;

    public CombatGroupView(CombatGroup combatGroup, Game game) {
        Player player = game.getPlayer(combatGroup.getDefenderId());
        if (player != null) {
            this.defenderName = player.getName();
        } else {
            Permanent perm = game.getPermanent(combatGroup.getDefenderId());
            if (perm != null) {
                this.defenderName = perm.getName();
            }
        }
        this.defenderId = combatGroup.getDefenderId();
        for (UUID id : combatGroup.getAttackers()) {
            Permanent attacker = game.getPermanent(id);
            if (attacker == null) continue;
            this.attackers.put(id, new PermanentView(attacker, game.getCard(attacker.getId()), null, game));
        }
        for (UUID id : combatGroup.getBlockers()) {
            Permanent blocker = game.getPermanent(id);
            if (blocker == null) continue;
            this.blockers.put(id, new PermanentView(blocker, game.getCard(blocker.getId()), null, game));
        }
        this.isBlocked = combatGroup.getBlocked();
    }

    public String getDefenderName() {
        return this.defenderName;
    }

    public CardsView getAttackers() {
        return this.attackers;
    }

    public CardsView getBlockers() {
        return this.blockers;
    }

    public UUID getDefenderId() {
        return this.defenderId;
    }

    public boolean isBlocked() {
        return this.isBlocked;
    }
}

