/*
 * Decompiled with CFR 0.152.
 */
package mage.view;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import mage.cards.ExpansionSet;
import mage.game.draft.Draft;
import mage.game.draft.DraftCube;
import mage.game.draft.DraftPlayer;

public class DraftView
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<String> setNames = new ArrayList<String>();
    private final List<String> setCodes = new ArrayList<String>();
    private final int boosterNum;
    private final int cardNum;
    private final boolean isCube;
    private final List<String> players = new ArrayList<String>();

    public DraftView(Draft draft) {
        boolean bl = this.isCube = draft.getDraftCube() != null;
        if (this.isCube) {
            for (int i = 0; i < draft.getNumberBoosters(); ++i) {
                DraftCube cube = draft.getDraftCube();
                this.setNames.add(cube.getName());
                this.setCodes.add(cube.getCode());
            }
        } else {
            for (ExpansionSet set : draft.getSets()) {
                this.setNames.add(set.getName());
                this.setCodes.add(set.getCode());
            }
        }
        this.boosterNum = draft.getBoosterNum();
        this.cardNum = draft.getCardNum();
        for (DraftPlayer draftPlayer : draft.getPlayers()) {
            this.players.add(draftPlayer.getPlayer().getName());
        }
    }

    public String getBoosterInfo(int index) {
        if (index >= this.setCodes.size() || this.setCodes.size() != this.setNames.size()) {
            return "error";
        }
        if (this.isCube) {
            return this.setNames.get(index);
        }
        return String.join((CharSequence)" - ", this.setCodes.get(index), this.setNames.get(index));
    }

    public List<String> getSetNames() {
        return this.setNames;
    }

    public List<String> getSetCodes() {
        return this.setCodes;
    }

    public List<String> getPlayers() {
        return this.players;
    }

    public int getBoosterNum() {
        return this.boosterNum;
    }

    public int getCardNum() {
        return this.cardNum;
    }
}

