/*
 * Decompiled with CFR 0.152.
 */
package mage.view;

import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import mage.MageObject;
import mage.game.Game;
import mage.game.command.Emblem;
import mage.game.command.emblems.EmblemOfCard;
import mage.players.PlayableObjectStats;
import mage.view.CommandObjectView;

public class EmblemView
implements CommandObjectView,
Serializable {
    protected UUID id;
    protected String name;
    protected String cardNumber = "";
    protected String imageFileName = "";
    protected int imageNumber;
    protected boolean usesVariousArt = false;
    protected String expansionSetCode;
    protected List<String> rules;
    protected PlayableObjectStats playableStats = new PlayableObjectStats();

    public EmblemView(Emblem emblem, Game game) {
        this.id = emblem.getId();
        this.name = emblem.getName();
        this.imageFileName = emblem.getImageFileName();
        this.imageNumber = emblem.getImageNumber();
        this.expansionSetCode = emblem.getExpansionSetCode();
        this.rules = emblem.getAbilities().getRules(game, (MageObject)emblem);
        if (emblem instanceof EmblemOfCard) {
            this.cardNumber = emblem.getCardNumber();
            this.usesVariousArt = ((EmblemOfCard)emblem).getUsesVariousArt();
        }
    }

    @Override
    public String getExpansionSetCode() {
        return this.expansionSetCode;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    public String getCardNumber() {
        return this.cardNumber;
    }

    @Override
    public String getImageFileName() {
        return this.imageFileName;
    }

    @Override
    public int getImageNumber() {
        return this.imageNumber;
    }

    public boolean getUsesVariousArt() {
        return this.usesVariousArt;
    }

    @Override
    public List<String> getRules() {
        return this.rules;
    }

    @Override
    public boolean isPlayable() {
        return this.playableStats.getPlayableAmount() > 0;
    }

    @Override
    public void setPlayableStats(PlayableObjectStats playableStats) {
        this.playableStats = playableStats;
    }

    @Override
    public PlayableObjectStats getPlayableStats() {
        return this.playableStats;
    }

    @Override
    public boolean isChoosable() {
        return false;
    }

    @Override
    public void setChoosable(boolean isChoosable) {
    }

    @Override
    public boolean isSelected() {
        return false;
    }

    @Override
    public void setSelected(boolean isSelected) {
    }
}

