/*
 * Decompiled with CFR 0.152.
 */
package mage.view;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import mage.game.Game;
import mage.game.Table;
import mage.game.match.Match;
import mage.game.match.MatchPlayer;
import mage.game.tournament.TournamentPlayer;

public class MatchView
implements Serializable {
    private final UUID tableId;
    private UUID matchId;
    private String matchName;
    private String gameType;
    private String deckType;
    private final List<UUID> games = new ArrayList<UUID>();
    private String result;
    private String players;
    private Date startTime;
    private Date endTime;
    private boolean replayAvailable;
    private final boolean isTournament;
    private boolean rated;

    public MatchView(Table table) {
        this.tableId = table.getId();
        this.isTournament = table.isTournament();
        if (table.isTournament()) {
            this.initTournamentTable(table);
        } else {
            this.initMatchTable(table);
        }
    }

    private void initMatchTable(Table table) {
        Match match = table.getMatch();
        this.matchId = match.getId();
        this.matchName = match.getName();
        this.gameType = match.getOptions().getGameType();
        this.deckType = table.getName() != null && !table.getName().isEmpty() ? match.getOptions().getDeckType() + " [" + table.getName() + ']' : match.getOptions().getDeckType();
        for (Game game : match.getGames()) {
            this.games.add(game.getId());
        }
        StringBuilder sb1 = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        for (MatchPlayer matchPlayer : match.getPlayers()) {
            sb1.append(matchPlayer.getName());
            if (matchPlayer.hasQuit()) {
                if (matchPlayer.getPlayer().hasTimerTimeout()) {
                    sb1.append(" [timer] ");
                } else if (matchPlayer.getPlayer().hasIdleTimeout()) {
                    sb1.append(" [idle] ");
                } else {
                    sb1.append(" [quit] ");
                }
            }
            int lostGames = match.getNumGames() - (matchPlayer.getWins() + match.getDraws());
            sb1.append(", ");
            sb2.append(matchPlayer.getName()).append(" [");
            sb2.append(matchPlayer.getWins()).append('-');
            if (match.getDraws() > 0) {
                sb2.append(match.getDraws()).append('-');
            }
            sb2.append(lostGames).append("], ");
        }
        if (sb1.length() > 2) {
            this.players = sb1.substring(0, sb1.length() - 2);
            this.result = sb2.substring(0, sb2.length() - 2);
        } else {
            this.players = "[no players]";
            this.result = "";
        }
        this.startTime = match.getStartTime();
        this.endTime = match.getEndTime();
        this.replayAvailable = match.isReplayAvailable();
        this.rated = match.getOptions().isRated();
    }

    private void initTournamentTable(Table table) {
        this.matchId = table.getTournament().getId();
        this.matchName = table.getName();
        this.gameType = table.getGameType();
        if (table.getTournament().getOptions().getNumberRounds() > 0) {
            this.gameType = this.gameType + ' ' + table.getTournament().getOptions().getNumberRounds() + " Rounds";
        }
        StringBuilder sbDeckType = new StringBuilder(table.getDeckType());
        if (!table.getTournament().getBoosterInfo().isEmpty()) {
            sbDeckType.append(' ').append(table.getTournament().getBoosterInfo());
        }
        if (table.getName() != null && !table.getName().isEmpty()) {
            sbDeckType.append(table.getDeckType()).append(" [").append(table.getName()).append(']');
        }
        this.deckType = sbDeckType.toString();
        StringBuilder sb1 = new StringBuilder();
        for (TournamentPlayer tPlayer : table.getTournament().getPlayers()) {
            sb1.append(tPlayer.getPlayer().getName()).append(" (").append(tPlayer.getPoints()).append(" P.) ");
        }
        this.players = sb1.toString();
        StringBuilder sb2 = new StringBuilder();
        if (!table.getTournament().getRounds().isEmpty()) {
            for (TournamentPlayer tPlayer : table.getTournament().getPlayers()) {
                sb2.append(tPlayer.getPlayer().getName()).append(": ").append(tPlayer.getResults()).append(' ');
            }
        } else if (table.getTournament().getOptions().getMatchOptions().isSingleGameTourney()) {
            sb2.append("Started single game");
        } else {
            sb2.append("Canceled");
        }
        this.result = sb2.toString();
        this.startTime = table.getTournament().getStartTime();
        this.endTime = table.getTournament().getEndTime();
        this.replayAvailable = false;
        this.rated = table.getTournament().getOptions().getMatchOptions().isRated();
    }

    public UUID getMatchId() {
        return this.matchId;
    }

    public String getName() {
        return this.matchName;
    }

    public String getGameType() {
        return this.gameType;
    }

    public String getDeckType() {
        return this.deckType;
    }

    public List<UUID> getGames() {
        return this.games;
    }

    public String getResult() {
        return this.result;
    }

    public String getPlayers() {
        return this.players;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getMatchName() {
        return this.matchName;
    }

    public boolean isReplayAvailable() {
        return this.replayAvailable;
    }

    public boolean isTournament() {
        return this.isTournament;
    }

    public UUID getTableId() {
        return this.tableId;
    }

    public boolean isRated() {
        return this.rated;
    }
}

