/*
 * Decompiled with CFR 0.152.
 */
package mage.view;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import mage.cards.Card;
import mage.counters.Counter;
import mage.designations.Designation;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.GameState;
import mage.game.command.CommandObject;
import mage.game.command.Commander;
import mage.game.command.Dungeon;
import mage.game.command.Emblem;
import mage.game.command.Plane;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.players.net.UserData;
import mage.util.CardUtil;
import mage.view.CardView;
import mage.view.CardsView;
import mage.view.CommandObjectView;
import mage.view.CommanderView;
import mage.view.CounterView;
import mage.view.DungeonView;
import mage.view.EmblemView;
import mage.view.ManaPoolView;
import mage.view.PermanentView;
import mage.view.PlaneView;

public class PlayerView
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final UUID playerId;
    private final String name;
    private final boolean controlled;
    private final boolean isHuman;
    private final int life;
    private final List<CounterView> counters;
    private final int wins;
    private final int winsNeeded;
    private final int libraryCount;
    private final int handCount;
    private final boolean isActive;
    private final boolean hasPriority;
    private final boolean timerActive;
    private final boolean hasLeft;
    private final ManaPoolView manaPool;
    private final CardsView graveyard = new CardsView();
    private final CardsView exile = new CardsView();
    private final CardsView sideboard = new CardsView();
    private final CardsView helperCards = new CardsView();
    private final Map<UUID, PermanentView> battlefield = new LinkedHashMap<UUID, PermanentView>();
    private final CardView topCard;
    private final UserData userData;
    private final List<CommandObjectView> commandList = new ArrayList<CommandObjectView>();
    private final List<UUID> attachments = new ArrayList<UUID>();
    private final int statesSavedSize;
    private final long priorityTimeSavedTimeMs;
    private final int priorityTimeLeftSecs;
    private final int bufferTimeLeft;
    private final boolean passedTurn;
    private final boolean passedUntilEndOfTurn;
    private final boolean passedUntilNextMain;
    private final boolean passedUntilStackResolved;
    private final boolean passedAllTurns;
    private final boolean passedUntilEndStepBeforeMyTurn;
    private final boolean monarch;
    private final boolean initiative;
    private final List<String> designationNames = new ArrayList<String>();

    public PlayerView(Player player, GameState state, Game game, UUID createdForPlayerId, UUID watcherUserId) {
        this.playerId = player.getId();
        this.name = player.getName();
        this.controlled = player.getId().equals(createdForPlayerId);
        this.isHuman = player.isHuman();
        this.life = player.getLife();
        this.wins = player.getMatchPlayer().getWins();
        this.winsNeeded = player.getMatchPlayer().getWinsNeeded();
        this.libraryCount = player.getLibrary().size();
        this.handCount = player.getHand().size();
        this.manaPool = new ManaPoolView(player.getManaPool());
        this.isActive = player.getId().equals(state.getActivePlayerId());
        this.hasPriority = player.getId().equals(state.getPriorityPlayerId());
        this.priorityTimeLeftSecs = player.getPriorityTimeLeft();
        this.priorityTimeSavedTimeMs = System.currentTimeMillis();
        this.bufferTimeLeft = player.getBufferTimeLeft();
        this.timerActive = this.hasPriority && player.isGameUnderControl() || player.getPlayersUnderYourControl().contains(state.getPriorityPlayerId()) || player.getId().equals(game.getState().getChoosingPlayerId());
        this.hasLeft = player.hasLeft();
        for (Card card : player.getGraveyard().getCards(game)) {
            this.graveyard.put(card.getId(), new CardView(card, game, CardUtil.canShowAsControlled((Card)card, (UUID)createdForPlayerId)));
        }
        for (ExileZone exileZone : game.getExile().getExileZones()) {
            for (Card card : exileZone.getCards(game)) {
                if (!player.getId().equals(card.getOwnerId())) continue;
                this.exile.put(card.getId(), new CardView(card, game, CardUtil.canShowAsControlled((Card)card, (UUID)createdForPlayerId)));
            }
        }
        if (this.controlled || !player.isHuman()) {
            for (Card card : player.getSideboard().getCards(game)) {
                this.sideboard.put(card.getId(), new CardView(card, game, CardUtil.canShowAsControlled((Card)card, (UUID)createdForPlayerId)));
            }
        }
        for (Permanent permanent : state.getBattlefield().getAllPermanents()) {
            if (!this.showInBattlefield(permanent, state)) continue;
            PermanentView view = new PermanentView(permanent, game.getCard(permanent.getId()), createdForPlayerId, game);
            this.battlefield.put(view.getId(), view);
        }
        Card cardOnTop = player.isTopCardRevealed() && player.getLibrary().hasCards() ? player.getLibrary().getFromTop(game) : null;
        this.topCard = cardOnTop != null ? new CardView(cardOnTop, game) : null;
        this.userData = player.getUserData() != null ? player.getUserData() : UserData.getDefaultUserDataView();
        for (CommandObject commandObject : game.getState().getCommand()) {
            Card sourceCard;
            Commander commander;
            if (commandObject instanceof Emblem) {
                Emblem emblem = (Emblem)commandObject;
                if (!emblem.getControllerId().equals(this.playerId)) continue;
                this.commandList.add(new EmblemView(emblem, game));
                continue;
            }
            if (commandObject instanceof Dungeon) {
                Dungeon dungeon = (Dungeon)commandObject;
                if (!dungeon.getControllerId().equals(this.playerId)) continue;
                this.commandList.add(new DungeonView(dungeon));
                continue;
            }
            if (commandObject instanceof Plane) {
                Plane plane = (Plane)commandObject;
                this.commandList.add(new PlaneView(plane, game));
                continue;
            }
            if (!(commandObject instanceof Commander) || !(commander = (Commander)commandObject).getControllerId().equals(this.playerId) || (sourceCard = game.getCard(commander.getSourceId())) == null) continue;
            this.commandList.add(new CommanderView(commander, sourceCard, game, createdForPlayerId));
        }
        if (player.getAttachments() != null) {
            this.attachments.addAll(player.getAttachments());
        }
        this.statesSavedSize = player.getStoredBookmark();
        this.passedTurn = player.getPassedTurn();
        this.passedUntilEndOfTurn = player.getPassedUntilEndOfTurn();
        this.passedUntilNextMain = player.getPassedUntilNextMain();
        this.passedAllTurns = player.getPassedAllTurns();
        this.passedUntilStackResolved = player.getPassedUntilStackResolved();
        this.passedUntilEndStepBeforeMyTurn = player.getPassedUntilEndStepBeforeMyTurn();
        this.monarch = player.getId().equals(game.getMonarchId());
        this.initiative = player.getId().equals(game.getInitiativeId());
        for (Designation designation : player.getDesignations()) {
            this.designationNames.add(designation.getName());
        }
        this.counters = new ArrayList<CounterView>();
        for (Counter counter : player.getCountersAsCopy().values()) {
            this.counters.add(new CounterView(counter));
        }
    }

    private boolean showInBattlefield(Permanent permanent, GameState state) {
        if (permanent.getAttachedTo() == null) {
            return permanent.getControllerId().equals(this.playerId);
        }
        Permanent attachedTo = state.getPermanent(permanent.getAttachedTo());
        if (attachedTo != null) {
            return attachedTo.getControllerId().equals(this.playerId);
        }
        return permanent.getControllerId().equals(this.playerId);
    }

    public boolean getControlled() {
        return this.controlled;
    }

    public boolean isHuman() {
        return this.isHuman;
    }

    public int getLife() {
        return this.life;
    }

    public List<CounterView> getCounters() {
        return this.counters;
    }

    public int getLibraryCount() {
        return this.libraryCount;
    }

    public int getWins() {
        return this.wins;
    }

    public int getWinsNeeded() {
        return this.winsNeeded;
    }

    public int getHandCount() {
        return this.handCount;
    }

    public ManaPoolView getManaPool() {
        return this.manaPool;
    }

    public CardsView getGraveyard() {
        return this.graveyard;
    }

    public CardsView getExile() {
        return this.exile;
    }

    public CardsView getSideboard() {
        return this.sideboard;
    }

    public Map<UUID, PermanentView> getBattlefield() {
        return this.battlefield;
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public String getName() {
        return this.name;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean hasLeft() {
        return this.hasLeft;
    }

    public CardView getTopCard() {
        return this.topCard;
    }

    public UserData getUserData() {
        return this.userData;
    }

    public List<CommandObjectView> getCommandObjectList() {
        return this.commandList;
    }

    public List<UUID> getAttachments() {
        return this.attachments;
    }

    public boolean hasAttachments() {
        return this.attachments != null && !this.attachments.isEmpty();
    }

    public int getStatesSavedSize() {
        return this.statesSavedSize;
    }

    public int getPriorityTimeLeftSecs() {
        int secsAfterUpdate = (int)((System.currentTimeMillis() - this.priorityTimeSavedTimeMs) / 1000L);
        return Math.max(0, this.priorityTimeLeftSecs - secsAfterUpdate);
    }

    public int getBufferTimeLeft() {
        return this.bufferTimeLeft;
    }

    public boolean hasPriority() {
        return this.hasPriority;
    }

    public boolean isTimerActive() {
        return this.timerActive;
    }

    public boolean isPassedTurn() {
        return this.passedTurn;
    }

    public boolean isPassedUntilEndOfTurn() {
        return this.passedUntilEndOfTurn;
    }

    public boolean isPassedUntilNextMain() {
        return this.passedUntilNextMain;
    }

    public boolean isPassedAllTurns() {
        return this.passedAllTurns;
    }

    public boolean isPassedUntilStackResolved() {
        return this.passedUntilStackResolved;
    }

    public boolean isPassedUntilEndStepBeforeMyTurn() {
        return this.passedUntilEndStepBeforeMyTurn;
    }

    public boolean isMonarch() {
        return this.monarch;
    }

    public boolean isInitiative() {
        return this.initiative;
    }

    public List<String> getDesignationNames() {
        return this.designationNames;
    }
}

