/*
 * Decompiled with CFR 0.152.
 */
package mage.view;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import mage.game.tournament.Round;
import mage.game.tournament.Tournament;
import mage.game.tournament.TournamentPlayer;
import mage.view.RoundView;
import mage.view.TournamentPlayerView;

public class TournamentView
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String tournamentName;
    private final String tournamentType;
    private final String tournamentState;
    private final Date startTime;
    private final Date endTime;
    private final Date stepStartTime;
    private final Date serverTime;
    private final int constructionTime;
    private final boolean watchingAllowed;
    private final List<RoundView> rounds = new ArrayList<RoundView>();
    private final List<TournamentPlayerView> players = new ArrayList<TournamentPlayerView>();
    private final String runningInfo;

    public TournamentView(Tournament tournament) {
        this.tournamentName = tournament.getOptions().getName();
        StringBuilder typeText = new StringBuilder(tournament.getOptions().getTournamentType());
        if (!tournament.getTournamentType().isLimited()) {
            typeText.append(" / ").append(tournament.getOptions().getMatchOptions().getDeckType());
        }
        if (tournament.getNumberRounds() > 0) {
            typeText.append(' ').append(tournament.getNumberRounds()).append(" rounds");
        }
        this.tournamentType = typeText.toString();
        this.startTime = tournament.getStartTime();
        this.endTime = tournament.getEndTime();
        this.stepStartTime = tournament.getStepStartTime();
        this.constructionTime = tournament.getOptions().getLimitedOptions().getConstructionTime();
        this.watchingAllowed = tournament.getOptions().isWatchingAllowed();
        this.serverTime = new Date();
        this.tournamentState = tournament.getTournamentState();
        this.runningInfo = tournament.getTournamentState().equals("Drafting") && tournament.getDraft() != null ? "booster/card: " + tournament.getDraft().getBoosterNum() + '/' + tournament.getDraft().getCardNum() : (tournament.getOptions().getMatchOptions().isSingleGameTourney() ? "running single game match" : "");
        for (TournamentPlayer player : tournament.getPlayers()) {
            this.players.add(new TournamentPlayerView(player));
        }
        Collections.sort(this.players);
        for (Round round : tournament.getRounds()) {
            this.rounds.add(new RoundView(round));
        }
    }

    public String getTournamentName() {
        return this.tournamentName;
    }

    public String getTournamentType() {
        return this.tournamentType;
    }

    public Date getStartTime() {
        return new Date(this.startTime.getTime());
    }

    public Date getEndTime() {
        if (this.endTime == null) {
            return null;
        }
        return new Date(this.endTime.getTime());
    }

    public boolean isWatchingAllowed() {
        return this.watchingAllowed;
    }

    public List<TournamentPlayerView> getPlayers() {
        return this.players;
    }

    public List<RoundView> getRounds() {
        return this.rounds;
    }

    public String getTournamentState() {
        return this.tournamentState;
    }

    public Date getStepStartTime() {
        return this.stepStartTime;
    }

    public int getConstructionTime() {
        return this.constructionTime;
    }

    public Date getServerTime() {
        return this.serverTime;
    }

    public String getRunningInfo() {
        return this.runningInfo;
    }
}

