/*
 * Decompiled with CFR 0.152.
 */
package mage.server;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.jdbc.JdbcConnectionSource;
import com.j256.ormlite.stmt.DeleteBuilder;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.SelectArg;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.support.DatabaseConnection;
import com.j256.ormlite.table.TableUtils;
import java.io.File;
import java.sql.SQLException;
import java.util.List;
import mage.cards.repository.CardRepository;
import mage.cards.repository.DatabaseUtils;
import mage.cards.repository.RepositoryUtil;
import mage.server.AuthorizedUser;
import org.apache.log4j.Logger;
import org.apache.shiro.crypto.RandomNumberGenerator;
import org.apache.shiro.crypto.SecureRandomNumberGenerator;
import org.apache.shiro.crypto.hash.Hash;
import org.apache.shiro.crypto.hash.SimpleHash;

public class AuthorizedUserRepository {
    private static final String VERSION_ENTITY_NAME = "authorized_user";
    private static final long DB_VERSION = 2L;
    private static final RandomNumberGenerator rng = new SecureRandomNumberGenerator();
    private static final AuthorizedUserRepository instance = new AuthorizedUserRepository(DatabaseUtils.prepareH2Connection("authorized_user.h2", false));
    private Dao<AuthorizedUser, Object> usersDao;

    public AuthorizedUserRepository(String connectionString) {
        File file = new File("db");
        if (!file.exists()) {
            file.mkdirs();
        }
        try {
            JdbcConnectionSource connectionSource = new JdbcConnectionSource(connectionString);
            TableUtils.createTableIfNotExists((ConnectionSource)connectionSource, AuthorizedUser.class);
            this.usersDao = DaoManager.createDao((ConnectionSource)connectionSource, AuthorizedUser.class);
        }
        catch (SQLException ex) {
            Logger.getLogger(AuthorizedUserRepository.class).error((Object)"Error creating / assigning authorized_user repository - ", (Throwable)ex);
        }
    }

    public static AuthorizedUserRepository getInstance() {
        return instance;
    }

    public void add(String userName, String password, String email) {
        try {
            SimpleHash hash = new SimpleHash("SHA-256", (Object)password, (Object)rng.nextBytes(), 1024);
            AuthorizedUser user = new AuthorizedUser(userName, (Hash)hash, email);
            this.usersDao.create((Object)user);
        }
        catch (SQLException ex) {
            Logger.getLogger(AuthorizedUserRepository.class).error((Object)"Error adding a user to DB - ", (Throwable)ex);
        }
    }

    public void remove(String userName) {
        try {
            DeleteBuilder db = this.usersDao.deleteBuilder();
            db.where().eq("name", (Object)new SelectArg((Object)userName));
            db.delete();
        }
        catch (SQLException ex) {
            Logger.getLogger(AuthorizedUserRepository.class).error((Object)"Error removing a user from DB - ", (Throwable)ex);
        }
    }

    public AuthorizedUser getByName(String userName) {
        try {
            QueryBuilder qb = this.usersDao.queryBuilder();
            qb.where().eq("name", (Object)new SelectArg((Object)userName));
            List results = this.usersDao.query(qb.prepare());
            if (results.size() == 1) {
                return (AuthorizedUser)results.get(0);
            }
            return null;
        }
        catch (SQLException ex) {
            Logger.getLogger(AuthorizedUserRepository.class).error((Object)"Error getting a authorized_user - ", (Throwable)ex);
            return null;
        }
    }

    public void update(AuthorizedUser authorizedUser) {
        try {
            this.usersDao.update((Object)authorizedUser);
        }
        catch (SQLException ex) {
            Logger.getLogger(AuthorizedUserRepository.class).error((Object)"Error updating authorized_user", (Throwable)ex);
        }
    }

    public AuthorizedUser getByEmail(String userName) {
        try {
            QueryBuilder qb = this.usersDao.queryBuilder();
            qb.where().eq("email", (Object)new SelectArg((Object)userName));
            List results = this.usersDao.query(qb.prepare());
            if (results.size() == 1) {
                return (AuthorizedUser)results.get(0);
            }
            return null;
        }
        catch (SQLException ex) {
            Logger.getLogger(AuthorizedUserRepository.class).error((Object)"Error getting a authorized_user - ", (Throwable)ex);
            return null;
        }
    }

    public void closeDB() {
        try {
            if (this.usersDao != null && this.usersDao.getConnectionSource() != null) {
                DatabaseConnection conn = this.usersDao.getConnectionSource().getReadWriteConnection(this.usersDao.getTableName());
                conn.executeStatement("SHUTDOWN IMMEDIATELY", -1);
                this.usersDao.getConnectionSource().releaseConnection(conn);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(AuthorizedUserRepository.class).error((Object)"Error closing authorized_user repository - ", (Throwable)ex);
        }
    }

    public long getDBVersionFromDB() {
        try {
            JdbcConnectionSource connectionSource = new JdbcConnectionSource(DatabaseUtils.prepareH2Connection("authorized_user.h2", false));
            return RepositoryUtil.getDatabaseVersion((ConnectionSource)connectionSource, VERSION_ENTITY_NAME);
        }
        catch (SQLException ex) {
            Logger.getLogger(CardRepository.class).error((Object)"Error getting DB version from DB - ", (Throwable)ex);
            return 0L;
        }
    }

    public boolean checkAlterAndMigrateAuthorizedUser() {
        long currentDBVersion = this.getDBVersionFromDB();
        if (currentDBVersion == 1L) {
            return this.migrateFrom1To2();
        }
        return true;
    }

    private boolean migrateFrom1To2() {
        try {
            Logger.getLogger(AuthorizedUserRepository.class).info((Object)"Starting authorized_user DB migration from version 1 to version 2");
            this.usersDao.executeRaw("ALTER TABLE authorized_user ADD COLUMN active BOOLEAN DEFAULT true;", new String[0]);
            this.usersDao.executeRaw("ALTER TABLE authorized_user ADD COLUMN lockedUntil DATETIME;", new String[0]);
            this.usersDao.executeRaw("ALTER TABLE authorized_user ADD COLUMN chatLockedUntil DATETIME;", new String[0]);
            this.usersDao.executeRaw("ALTER TABLE authorized_user ADD COLUMN lastConnection DATETIME;", new String[0]);
            RepositoryUtil.updateVersion(this.usersDao.getConnectionSource(), VERSION_ENTITY_NAME, 2L);
            Logger.getLogger(AuthorizedUserRepository.class).info((Object)"Migration finished.");
            return true;
        }
        catch (SQLException ex) {
            Logger.getLogger(AuthorizedUserRepository.class).error((Object)"Error while migrating from version 1 to version 2 - ", (Throwable)ex);
            return false;
        }
    }
}

