/*
 * Decompiled with CFR 0.152.
 */
package mage.server;

import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import mage.server.Main;
import mage.server.managers.ConfigSettings;
import mage.server.managers.MailClient;
import org.apache.log4j.Logger;

public class MailClientImpl
implements MailClient {
    private static final Logger logger = Logger.getLogger(Main.class);
    private final ConfigSettings config;

    public MailClientImpl(ConfigSettings config) {
        this.config = config;
    }

    @Override
    public boolean sendMessage(String email, String subject, String text) {
        if (email.isEmpty()) {
            logger.info((Object)"Email is not sent because the address is empty");
            return false;
        }
        Properties properties = System.getProperties();
        properties.setProperty("mail.smtps.host", this.config.getMailSmtpHost());
        properties.setProperty("mail.smtps.port", this.config.getMailSmtpPort());
        properties.setProperty("mail.smtps.auth", "true");
        properties.setProperty("mail.user", this.config.getMailUser());
        properties.setProperty("mail.password", this.config.getMailPassword());
        Session session = Session.getDefaultInstance((Properties)properties);
        try {
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(this.config.getMailFromAddress()));
            message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(email));
            message.setSubject(subject);
            message.setText(text);
            Transport trnsport = session.getTransport("smtps");
            trnsport.connect(null, properties.getProperty("mail.password"));
            message.saveChanges();
            trnsport.sendMessage((Message)message, message.getAllRecipients());
            trnsport.close();
            return true;
        }
        catch (MessagingException ex) {
            logger.error((Object)("Error sending message to " + email), (Throwable)ex);
            return false;
        }
    }
}

