/*
 * Decompiled with CFR 0.152.
 */
package mage.server;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import mage.cards.decks.Deck;
import mage.constants.ManaType;
import mage.constants.TableState;
import mage.game.Table;
import mage.game.draft.DraftPlayer;
import mage.game.result.ResultProtos;
import mage.game.tournament.TournamentPlayer;
import mage.interfaces.callback.ClientCallback;
import mage.interfaces.callback.ClientCallbackMethod;
import mage.players.net.UserData;
import mage.server.AuthorizedUser;
import mage.server.AuthorizedUserRepository;
import mage.server.DisconnectReason;
import mage.server.TableController;
import mage.server.draft.DraftSession;
import mage.server.game.GameController;
import mage.server.game.GameSessionPlayer;
import mage.server.managers.ManagerFactory;
import mage.server.rating.GlickoRating;
import mage.server.rating.GlickoRatingSystem;
import mage.server.record.UserStats;
import mage.server.record.UserStatsRepository;
import mage.server.tournament.TournamentController;
import mage.server.tournament.TournamentSession;
import mage.server.util.ServerMessagesUtil;
import mage.utils.SystemUtil;
import mage.view.TableClientMessage;
import org.apache.log4j.Logger;

public class User {
    private static final Logger logger = Logger.getLogger(User.class);
    public static final String ADMIN_NAME = "Admin";
    private final ManagerFactory managerFactory;
    private final UUID userId;
    private final String userName;
    private final String host;
    private final Date connectionTime;
    private final Map<UUID, Table> tables;
    private final List<UUID> tablesToDelete;
    private final Map<UUID, GameSessionPlayer> gameSessions;
    private final Map<UUID, DraftSession> draftSessions;
    private final Map<UUID, UUID> userTournaments;
    private final Map<UUID, TournamentSession> constructing;
    private final Map<UUID, Deck> sideboarding;
    private final List<UUID> watchedGames;
    private String sessionId;
    private String restoreSessionId;
    private String pingInfo = "";
    private Date lastActivity;
    private UserState userState;
    private UserData userData;
    private UserStats userStats;
    private Date chatLockedUntil;
    private boolean active;
    private Date lockedUntil;
    private final AuthorizedUser authorizedUser;
    private String clientVersion;
    private String userIdStr;

    public User(ManagerFactory managerFactory, String userName, String host, AuthorizedUser authorizedUser) {
        this.managerFactory = managerFactory;
        this.userId = UUID.randomUUID();
        this.userName = userName;
        this.host = host;
        this.userState = UserState.Created;
        this.connectionTime = new Date();
        this.lastActivity = new Date();
        if (authorizedUser != null) {
            this.active = authorizedUser.active;
            this.chatLockedUntil = authorizedUser.chatLockedUntil;
            this.lockedUntil = authorizedUser.lockedUntil;
            this.authorizedUser = authorizedUser;
            this.updateAuthorizedUser();
        } else {
            this.active = true;
            this.chatLockedUntil = null;
            this.lockedUntil = null;
            this.authorizedUser = null;
        }
        this.tables = new ConcurrentHashMap<UUID, Table>();
        this.gameSessions = new ConcurrentHashMap<UUID, GameSessionPlayer>();
        this.draftSessions = new ConcurrentHashMap<UUID, DraftSession>();
        this.userTournaments = new ConcurrentHashMap<UUID, UUID>();
        this.constructing = new ConcurrentHashMap<UUID, TournamentSession>();
        this.sideboarding = new ConcurrentHashMap<UUID, Deck>();
        this.watchedGames = new ArrayList<UUID>();
        this.tablesToDelete = new ArrayList<UUID>();
        this.sessionId = "";
        this.clientVersion = "";
        this.userIdStr = "";
    }

    public String getName() {
        return this.userName;
    }

    public UUID getId() {
        return this.userId;
    }

    public String getHost() {
        return this.host;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getRestoreSessionId() {
        return this.restoreSessionId;
    }

    public Date getChatLockedUntil() {
        return this.chatLockedUntil;
    }

    public boolean isActive() {
        return this.active;
    }

    public Date getLockedUntil() {
        return this.lockedUntil;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public void setRestoreSessionId(String restoreSessionId) {
        this.restoreSessionId = restoreSessionId;
    }

    public void setClientVersion(String clientVersion) {
        this.clientVersion = clientVersion;
    }

    public void setUserIdStr(String userIdStr) {
        this.userIdStr = userIdStr;
    }

    public String getUserIdStr() {
        return this.userIdStr;
    }

    public String getClientVersion() {
        return this.clientVersion;
    }

    public void setChatLockedUntil(Date chatLockedUntil) {
        this.chatLockedUntil = chatLockedUntil;
        this.updateAuthorizedUser();
    }

    public void setActive(boolean active) {
        this.active = active;
        this.updateAuthorizedUser();
    }

    public void setLockedUntil(Date lockedUntil) {
        this.lockedUntil = lockedUntil;
        this.updateAuthorizedUser();
    }

    public void onLostConnection(DisconnectReason reason) {
        if (reason != DisconnectReason.DisconnectedByUser && reason != DisconnectReason.DisconnectedByUserButKeepTables) {
            ServerMessagesUtil.instance.incLostConnection();
        }
        this.managerFactory.chatManager().removeUser(this.userId, reason);
        Iterator<UUID> iterator = this.watchedGames.iterator();
        while (iterator.hasNext()) {
            UUID gameId = iterator.next();
            this.managerFactory.gameManager().stopWatching(gameId, this.userId);
            iterator.remove();
        }
        if (reason.isRemoveUserTables) {
            this.removeUserFromAllTables(reason);
            this.setUserState(UserState.Offline);
            this.managerFactory.userManager().removeUser(this.getId());
        } else {
            this.setUserState(UserState.Disconnected);
        }
        String oldSessionId = this.sessionId;
        this.setSessionId("");
        this.managerFactory.sessionManager().disconnect(oldSessionId, reason, false);
    }

    public boolean isConnected() {
        return this.userState == UserState.Connected;
    }

    public String getDisconnectDuration() {
        return this.getSecondsDisconnected() + " secs";
    }

    public long getSecondsDisconnected() {
        return SystemUtil.getDateDiff((Date)this.lastActivity, (Date)new Date(), (TimeUnit)TimeUnit.SECONDS);
    }

    public Date getConnectionTime() {
        return this.connectionTime;
    }

    public Date getLastActivity() {
        return this.lastActivity;
    }

    public String getConnectionDuration() {
        int minutes = (int)SystemUtil.getDateDiff((Date)this.connectionTime, (Date)new Date(), (TimeUnit)TimeUnit.SECONDS) / 60;
        int hours = 0;
        if (minutes > 59) {
            hours = minutes / 60;
            minutes -= hours * 60;
        }
        String connTime = hours + ":" + (minutes > 9 ? Integer.toString(minutes) : '0' + Integer.toString(minutes));
        int lastSecs = (int)SystemUtil.getDateDiff((Date)this.lastActivity, (Date)new Date(), (TimeUnit)TimeUnit.SECONDS);
        return " (online: " + connTime + "; seen: " + lastSecs + " sec ago)";
    }

    public void fireCallback(ClientCallback call) {
        if (this.isConnected()) {
            this.managerFactory.sessionManager().getSession(this.sessionId).ifPresent(session -> session.fireCallback(call));
        }
    }

    public void ccJoinedTable(UUID roomId, UUID currentTableId, UUID parentTableId, boolean isTournament) {
        this.fireCallback(new ClientCallback(ClientCallbackMethod.JOINED_TABLE, currentTableId, (Object)new TableClientMessage().withRoom(roomId).withTable(currentTableId, parentTableId).withFlag(isTournament)));
    }

    public void ccGameStarted(UUID currentTableId, UUID parentTableId, UUID gameId, UUID playerId) {
        this.fireCallback(new ClientCallback(ClientCallbackMethod.START_GAME, gameId, (Object)new TableClientMessage().withTable(currentTableId, parentTableId).withGame(gameId).withPlayer(playerId)));
    }

    public void ccDraftStarted(UUID tableId, UUID draftId, UUID playerId) {
        this.fireCallback(new ClientCallback(ClientCallbackMethod.START_DRAFT, draftId, (Object)new TableClientMessage().withTable(tableId, null).withPlayer(playerId)));
    }

    public void ccTournamentStarted(UUID tableID, UUID tournamentId, UUID playerId) {
        this.fireCallback(new ClientCallback(ClientCallbackMethod.START_TOURNAMENT, tournamentId, (Object)new TableClientMessage().withTable(tableID, null).withPlayer(playerId)));
    }

    public void ccSideboard(Deck deck, UUID currentTableId, UUID parentTableId, int time, boolean limited) {
        this.fireCallback(new ClientCallback(ClientCallbackMethod.SIDEBOARD, currentTableId, (Object)new TableClientMessage().withDeck(deck).withTable(currentTableId, parentTableId).withTime(time).withFlag(limited)));
        this.sideboarding.put(currentTableId, deck);
    }

    public void ccViewLimitedDeck(Deck deck, UUID currentTableId, UUID parentTableId, int time, boolean limited) {
        this.fireCallback(new ClientCallback(ClientCallbackMethod.VIEW_LIMITED_DECK, currentTableId, (Object)new TableClientMessage().withDeck(deck).withTable(currentTableId, parentTableId).withTime(time).withFlag(limited)));
    }

    public void ccViewSideboard(UUID tableId, UUID gameId, UUID targetPlayerId) {
        this.fireCallback(new ClientCallback(ClientCallbackMethod.VIEW_SIDEBOARD, tableId, (Object)new TableClientMessage().withGame(gameId).withPlayer(targetPlayerId)));
    }

    public void ccConstruct(Deck deck, UUID currentTableId, UUID parentTableId, int time) {
        this.fireCallback(new ClientCallback(ClientCallbackMethod.CONSTRUCT, currentTableId, (Object)new TableClientMessage().withDeck(deck).withTable(currentTableId, parentTableId).withTime(time)));
    }

    public void ccShowTournament(UUID tableId, UUID tournamentId) {
        this.fireCallback(new ClientCallback(ClientCallbackMethod.SHOW_TOURNAMENT, tournamentId, (Object)new TableClientMessage().withTable(tableId, null)));
    }

    public void showUserMessage(String title, String message) {
        LinkedList<String> messageData = new LinkedList<String>();
        messageData.add(title);
        messageData.add(message);
        this.fireCallback(new ClientCallback(ClientCallbackMethod.SHOW_USERMESSAGE, null, messageData));
    }

    public boolean ccWatchGame(UUID currentTableId, UUID parentTableId, UUID gameId) {
        this.fireCallback(new ClientCallback(ClientCallbackMethod.WATCHGAME, gameId, (Object)new TableClientMessage().withTable(currentTableId, parentTableId)));
        return true;
    }

    public void ccReplayGame(UUID gameId) {
        this.fireCallback(new ClientCallback(ClientCallbackMethod.REPLAY_GAME, gameId));
    }

    public void sendPlayerUUID(UUID gameId, UUID data) {
        this.lastActivity = new Date();
        this.managerFactory.gameManager().sendPlayerUUID(gameId, this.userId, data);
    }

    public void sendPlayerString(UUID gameId, String data) {
        this.lastActivity = new Date();
        this.managerFactory.gameManager().sendPlayerString(gameId, this.userId, data);
    }

    public void sendPlayerManaType(UUID gameId, UUID playerId, ManaType data) {
        this.lastActivity = new Date();
        this.managerFactory.gameManager().sendPlayerManaType(gameId, playerId, this.userId, data);
    }

    public void sendPlayerBoolean(UUID gameId, Boolean data) {
        this.lastActivity = new Date();
        this.managerFactory.gameManager().sendPlayerBoolean(gameId, this.userId, data);
    }

    public void sendPlayerInteger(UUID gameId, Integer data) {
        this.lastActivity = new Date();
        this.managerFactory.gameManager().sendPlayerInteger(gameId, this.userId, data);
    }

    public void updateLastActivity(String pingInfo) {
        if (pingInfo != null) {
            this.pingInfo = pingInfo;
        }
        this.lastActivity = new Date();
        this.setUserState(UserState.Connected);
    }

    public boolean isExpired(Date expired) {
        if (this.lastActivity.before(expired)) {
            logger.trace((Object)(this.userName + " is expired!"));
            return true;
        }
        logger.trace((Object)("isExpired: User " + this.userName + " lastActivity: " + this.lastActivity + " expired: " + expired));
        return false;
    }

    public void onReconnect() {
        ServerMessagesUtil.instance.incReconnects();
        for (Map.Entry<UUID, Table> entry : this.tables.entrySet()) {
            this.ccJoinedTable(entry.getValue().getRoomId(), entry.getValue().getId(), entry.getValue().getParentTableId(), entry.getValue().isTournament());
        }
        Iterator<Map.Entry<UUID, UUID>> iterator = this.userTournaments.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, UUID> entry = iterator.next();
            Optional<TournamentController> tournamentController = this.managerFactory.tournamentManager().getTournamentController(entry.getValue());
            if (tournamentController.isPresent()) {
                this.ccTournamentStarted(tournamentController.get().getTableId(), entry.getValue(), entry.getKey());
                tournamentController.get().rejoin(entry.getKey());
                continue;
            }
            iterator.remove();
        }
        for (Map.Entry<UUID, Object> entry : this.gameSessions.entrySet()) {
            Table table;
            GameController gameController = this.managerFactory.gameManager().getGameController().getOrDefault(((GameSessionPlayer)entry.getValue()).getGameId(), null);
            if (gameController == null || (table = this.managerFactory.tableManager().getTable(gameController.getTableId())) == null) continue;
            this.ccGameStarted(table.getId(), table.getParentTableId(), ((GameSessionPlayer)entry.getValue()).getGameId(), entry.getKey());
            ((GameSessionPlayer)entry.getValue()).init();
            this.managerFactory.gameManager().sendPlayerString(((GameSessionPlayer)entry.getValue()).getGameId(), this.userId, "");
        }
        for (Map.Entry<UUID, Object> entry : this.draftSessions.entrySet()) {
            this.ccDraftStarted(((DraftSession)entry.getValue()).getDraft().getTableId(), ((DraftSession)entry.getValue()).getDraft().getId(), entry.getKey());
            ((DraftSession)entry.getValue()).init();
            ((DraftSession)entry.getValue()).update();
            DraftPlayer draftPlayer = ((DraftSession)entry.getValue()).getDraftPlayer();
            if (draftPlayer == null) continue;
            draftPlayer.setBoosterNotLoaded();
            ((DraftSession)entry.getValue()).getDraft().boosterSendingStart();
        }
        for (Map.Entry<UUID, Object> entry : this.constructing.entrySet()) {
            ((TournamentSession)entry.getValue()).construct(0);
        }
        for (Map.Entry<UUID, Object> entry : this.sideboarding.entrySet()) {
            TableController controller = this.managerFactory.tableManager().getController(entry.getKey()).orElse(null);
            if (controller != null) {
                this.ccSideboard((Deck)entry.getValue(), controller.getTable().getId(), controller.getTable().getParentTableId(), controller.getRemainingTime(), controller.getOptions().isLimited());
                continue;
            }
            logger.debug((Object)(this.getName() + " reconnects during sideboarding but tableId not found: " + entry.getKey()));
        }
    }

    public void addGame(UUID playerId, GameSessionPlayer gameSession) {
        this.gameSessions.put(playerId, gameSession);
    }

    public void removeGame(UUID playerId) {
        this.gameSessions.remove(playerId);
    }

    public void addDraft(UUID playerId, DraftSession draftSession) {
        this.draftSessions.put(playerId, draftSession);
    }

    public void removeDraft(UUID playerId) {
        this.draftSessions.remove(playerId);
    }

    public void addTournament(UUID playerId, UUID tournamentId) {
        this.userTournaments.put(playerId, tournamentId);
    }

    public void removeTournament(UUID playerId) {
        this.userTournaments.remove(playerId);
    }

    public void addTable(UUID playerId, Table table) {
        this.tables.put(playerId, table);
    }

    public void removeTable(UUID playerId) {
        this.tables.remove(playerId);
    }

    public void addConstructing(UUID playerId, TournamentSession tournamentSession) {
        this.constructing.put(playerId, tournamentSession);
    }

    public void removeConstructing(UUID playerId) {
        this.constructing.remove(playerId);
    }

    public void removeSideboarding(UUID tableId) {
        this.sideboarding.remove(tableId);
    }

    public void removeUserFromAllTables(DisconnectReason reason) {
        logger.trace((Object)("REMOVE " + this.userName + " Draft sessions " + this.draftSessions.size()));
        for (DraftSession draftSession : this.draftSessions.values()) {
            draftSession.setKilled();
        }
        this.draftSessions.clear();
        logger.trace((Object)("REMOVE " + this.userName + " Tournament sessions " + this.userTournaments.size()));
        for (UUID uUID : this.userTournaments.values()) {
            this.managerFactory.tournamentManager().quit(uUID, this.userId);
        }
        this.userTournaments.clear();
        this.constructing.clear();
        logger.trace((Object)("REMOVE " + this.userName + " Tables " + this.tables.size()));
        for (Map.Entry entry : this.tables.entrySet()) {
            logger.debug((Object)("-- leave tableId: " + ((Table)entry.getValue()).getId()));
            this.managerFactory.tableManager().leaveTable(this.userId, ((Table)entry.getValue()).getId());
        }
        this.tables.clear();
        this.sideboarding.clear();
        logger.trace((Object)("REMOVE " + this.userName + " Game sessions: " + this.gameSessions.size()));
        for (GameSessionPlayer gameSessionPlayer : this.gameSessions.values()) {
            logger.debug((Object)("-- kill game session of gameId: " + gameSessionPlayer.getGameId()));
            this.managerFactory.gameManager().quitMatch(gameSessionPlayer.getGameId(), this.userId);
            gameSessionPlayer.quitGame();
        }
        this.gameSessions.clear();
        logger.trace((Object)("REMOVE " + this.userName + " watched Games " + this.watchedGames.size()));
        for (UUID uUID : this.watchedGames) {
            this.managerFactory.gameManager().stopWatching(uUID, this.userId);
        }
        this.watchedGames.clear();
        logger.trace((Object)("REMOVE " + this.userName + " Chats "));
        this.managerFactory.chatManager().removeUser(this.userId, reason);
    }

    public void setUserData(UserData userData) {
        if (this.userData != null) {
            this.userData.update(userData);
        } else {
            this.userData = userData;
            this.resetUserStats();
        }
    }

    public UserData getUserData() {
        if (this.userData == null) {
            return UserData.getDefaultUserDataView();
        }
        return this.userData;
    }

    public String getGameInfo() {
        StringBuilder sb = new StringBuilder();
        int draft = 0;
        int match = 0;
        int sideboard = 0;
        int tournament = 0;
        int construct = 0;
        int waiting = 0;
        for (Map.Entry<UUID, Table> tableEntry : this.tables.entrySet()) {
            Table table;
            if (tableEntry == null || (table = tableEntry.getValue()) == null) continue;
            if (table.isTournament()) {
                if (tableEntry.getKey() != null) {
                    TournamentPlayer tournamentPlayer = table.getTournament().getPlayer(tableEntry.getKey());
                    if (tournamentPlayer != null) {
                        if (tournamentPlayer.isEliminated()) continue;
                        switch (table.getState()) {
                            case WAITING: 
                            case STARTING: 
                            case READY_TO_START: {
                                ++waiting;
                                break;
                            }
                            case CONSTRUCTING: {
                                ++construct;
                                break;
                            }
                            case DRAFTING: {
                                ++draft;
                                break;
                            }
                            case DUELING: {
                                ++tournament;
                            }
                        }
                        switch (this.getUserState()) {
                            case Disconnected: {
                                tournamentPlayer.setDisconnectInfo(" (discon. " + this.getDisconnectDuration() + ')');
                                break;
                            }
                            case Offline: {
                                tournamentPlayer.setDisconnectInfo(" Offline");
                                break;
                            }
                            default: {
                                tournamentPlayer.setDisconnectInfo("");
                                break;
                            }
                        }
                        continue;
                    }
                    logger.debug((Object)(this.userName + " tournament player missing - tableId:" + table.getId()), null);
                    this.tablesToDelete.add(tableEntry.getKey());
                    continue;
                }
                logger.error((Object)(this.userName + " tournament key missing - tableId: " + table.getId()), null);
                continue;
            }
            switch (table.getState()) {
                case WAITING: 
                case STARTING: 
                case READY_TO_START: {
                    ++waiting;
                    break;
                }
                case SIDEBOARDING: {
                    ++sideboard;
                    break;
                }
                case DUELING: {
                    ++match;
                }
            }
        }
        if (!this.tablesToDelete.isEmpty()) {
            for (UUID keyId : this.tablesToDelete) {
                this.removeTable(keyId);
            }
            this.tablesToDelete.clear();
        }
        if (waiting > 0) {
            sb.append("Wait: ").append(waiting).append(' ');
        }
        if (match > 0) {
            sb.append("Match: ").append(match).append(' ');
        }
        if (sideboard > 0) {
            sb.append("Sideb: ").append(sideboard).append(' ');
        }
        if (draft > 0) {
            sb.append("Draft: ").append(draft).append(' ');
        }
        if (construct > 0) {
            sb.append("Const: ").append(construct).append(' ');
        }
        if (tournament > 0) {
            sb.append("Tourn: ").append(tournament).append(' ');
        }
        if (!this.watchedGames.isEmpty()) {
            sb.append("Watch: ").append(this.watchedGames.size()).append(' ');
        }
        return sb.length() == 0 ? "not active" : sb.toString();
    }

    public void addGameWatchInfo(UUID gameId) {
        this.watchedGames.add(gameId);
    }

    public void removeGameWatchInfo(UUID gameId) {
        this.watchedGames.remove(gameId);
    }

    public UserState getUserState() {
        return this.userState;
    }

    public void setUserState(UserState userState) {
        this.userState = userState;
    }

    public String getPingInfo() {
        switch (this.getUserState()) {
            case Disconnected: {
                return " (discon. " + this.getDisconnectDuration() + ')';
            }
            case Offline: {
                return " Offline";
            }
        }
        return this.pingInfo + " " + this.getConnectionDuration();
    }

    public void resetUserStats() {
        if (this.userData == null) {
            return;
        }
        this.userStats = UserStatsRepository.instance.getUser(this.userName);
        if (this.userStats != null) {
            ResultProtos.UserStatsProto userStatsProto = this.userStats.getProto();
            this.userData.setMatchHistory(User.userStatsToMatchHistory(userStatsProto));
            this.userData.setMatchQuitRatio(User.userStatsToMatchQuitRatio(userStatsProto));
            this.userData.setTourneyHistory(User.userStatsToTourneyHistory(userStatsProto));
            this.userData.setTourneyQuitRatio(User.userStatsToTourneyQuitRatio(userStatsProto));
            this.userData.setGeneralRating(User.userStatsToGeneralRating(userStatsProto));
            this.userData.setConstructedRating(User.userStatsToConstructedRating(userStatsProto));
            this.userData.setLimitedRating(User.userStatsToLimitedRating(userStatsProto));
        } else {
            this.userData.setMatchHistory("0");
            this.userData.setMatchQuitRatio(0);
            this.userData.setTourneyHistory("0");
            this.userData.setTourneyQuitRatio(0);
            this.userData.setGeneralRating(GlickoRatingSystem.getDefaultDisplayedRating());
            this.userData.setConstructedRating(GlickoRatingSystem.getDefaultDisplayedRating());
            this.userData.setLimitedRating(GlickoRatingSystem.getDefaultDisplayedRating());
        }
    }

    public String getMatchHistory() {
        if (this.userData != null) {
            return this.userData.getMatchHistory();
        }
        return "<not available>";
    }

    public int getMatchQuitRatio() {
        if (this.userData != null) {
            return this.userData.getMatchQuitRatio();
        }
        return 0;
    }

    public String getTourneyHistory() {
        if (this.userData != null) {
            return this.userData.getTourneyHistory();
        }
        return "<not available>";
    }

    public static String userStatsToHistory(ResultProtos.UserStatsProto proto) {
        return "Matches:" + User.userStatsToMatchHistory(proto) + ", Tourneys: " + User.userStatsToTourneyHistory(proto) + ", Constructed Rating: " + User.userStatsToConstructedRating(proto) + ", Limited Rating: " + User.userStatsToLimitedRating(proto);
    }

    public int getTourneyQuitRatio() {
        if (this.userData != null) {
            return this.userData.getTourneyQuitRatio();
        }
        return 0;
    }

    public static String userStatsToMatchHistory(ResultProtos.UserStatsProto proto) {
        StringBuilder builder = new StringBuilder();
        builder.append(proto.getMatches());
        ArrayList<String> quit = new ArrayList<String>();
        if (proto.getMatchesIdleTimeout() > 0) {
            quit.add("I:" + proto.getMatchesIdleTimeout());
        }
        if (proto.getMatchesTimerTimeout() > 0) {
            quit.add("T:" + proto.getMatchesTimerTimeout());
        }
        if (proto.getMatchesQuit() > 0) {
            quit.add("Q:" + proto.getMatchesQuit());
        }
        if (!quit.isEmpty()) {
            builder.append(" (");
            User.joinStrings(builder, quit, " ");
            builder.append(')');
        }
        return builder.toString();
    }

    public static int userStatsToMatchQuitRatio(ResultProtos.UserStatsProto proto) {
        int matches = proto.getMatches();
        if (matches == 0) {
            return 0;
        }
        int quits = proto.getMatchesIdleTimeout() + proto.getMatchesTimerTimeout() + proto.getMatchesQuit();
        return 100 * quits / matches;
    }

    public static String userStatsToTourneyHistory(ResultProtos.UserStatsProto proto) {
        StringBuilder builder = new StringBuilder();
        builder.append(proto.getTourneys());
        ArrayList<String> quit = new ArrayList<String>();
        if (proto.getTourneysQuitDuringDrafting() > 0) {
            quit.add("D:" + proto.getTourneysQuitDuringDrafting());
        }
        if (proto.getTourneysQuitDuringConstruction() > 0) {
            quit.add("C:" + proto.getTourneysQuitDuringConstruction());
        }
        if (proto.getTourneysQuitDuringRound() > 0) {
            quit.add("R:" + proto.getTourneysQuitDuringRound());
        }
        if (!quit.isEmpty()) {
            builder.append(" (");
            User.joinStrings(builder, quit, " ");
            builder.append(')');
        }
        return builder.toString();
    }

    public static int userStatsToTourneyQuitRatio(ResultProtos.UserStatsProto proto) {
        int tourneys = proto.getTourneys();
        if (tourneys == 0) {
            return 0;
        }
        int quits = proto.getTourneysQuitDuringDrafting() + proto.getTourneysQuitDuringConstruction() + proto.getTourneysQuitDuringRound();
        return 100 * quits / tourneys;
    }

    private static int userStatsToGeneralRating(ResultProtos.UserStatsProto proto) {
        GlickoRating glickoRating;
        if (proto.hasGeneralGlickoRating()) {
            ResultProtos.GlickoRatingProto glickoRatingProto = proto.getGeneralGlickoRating();
            glickoRating = new GlickoRating(glickoRatingProto.getRating(), glickoRatingProto.getRatingDeviation(), glickoRatingProto.getLastGameTimeMs());
        } else {
            glickoRating = GlickoRatingSystem.getInitialRating();
        }
        return GlickoRatingSystem.getDisplayedRating(glickoRating);
    }

    private static int userStatsToConstructedRating(ResultProtos.UserStatsProto proto) {
        GlickoRating glickoRating;
        if (proto.hasConstructedGlickoRating()) {
            ResultProtos.GlickoRatingProto glickoRatingProto = proto.getConstructedGlickoRating();
            glickoRating = new GlickoRating(glickoRatingProto.getRating(), glickoRatingProto.getRatingDeviation(), glickoRatingProto.getLastGameTimeMs());
        } else {
            glickoRating = GlickoRatingSystem.getInitialRating();
        }
        return GlickoRatingSystem.getDisplayedRating(glickoRating);
    }

    private static int userStatsToLimitedRating(ResultProtos.UserStatsProto proto) {
        GlickoRating glickoRating;
        if (proto.hasLimitedGlickoRating()) {
            ResultProtos.GlickoRatingProto glickoRatingProto = proto.getLimitedGlickoRating();
            glickoRating = new GlickoRating(glickoRatingProto.getRating(), glickoRatingProto.getRatingDeviation(), glickoRatingProto.getLastGameTimeMs());
        } else {
            glickoRating = GlickoRatingSystem.getInitialRating();
        }
        return GlickoRatingSystem.getDisplayedRating(glickoRating);
    }

    private static void joinStrings(StringBuilder joined, List<String> strings, String separator) {
        for (int i = 0; i < strings.size(); ++i) {
            if (i > 0) {
                joined.append(separator);
            }
            joined.append(strings.get(i));
        }
    }

    public int getNumberOfNotStartedTables() {
        int number = 0;
        for (Table table : this.tables.values()) {
            if (table.getState() != TableState.WAITING && table.getState() != TableState.STARTING) continue;
            ++number;
        }
        return number;
    }

    public int getNumberOfNotFinishedTables() {
        int number = 0;
        for (Table table : this.tables.values()) {
            if (table.getState() == TableState.FINISHED) {
                ++number;
                continue;
            }
            Optional<TableController> tableController = this.managerFactory.tableManager().getController(table.getId());
            if (!tableController.isPresent()) {
                logger.error((Object)("table not found : " + table.getId()));
                continue;
            }
            if (!tableController.get().isUserStillActive(this.userId)) continue;
            ++number;
        }
        return number;
    }

    public String getEmail() {
        if (this.authorizedUser != null) {
            return this.authorizedUser.email;
        }
        return "";
    }

    private void updateAuthorizedUser() {
        if (this.authorizedUser != null) {
            this.authorizedUser.lastConnection = this.connectionTime;
            this.authorizedUser.chatLockedUntil = this.chatLockedUntil;
            this.authorizedUser.lockedUntil = this.lockedUntil;
            this.authorizedUser.active = this.active;
            AuthorizedUserRepository.getInstance().update(this.authorizedUser);
        }
    }

    public boolean isOnlineUser() {
        return this.getUserState() != UserState.Offline && !this.getName().equals(ADMIN_NAME);
    }

    public static enum UserState {
        Created,
        Connected,
        Disconnected,
        Offline;

    }
}

