/*
 * Decompiled with CFR 0.152.
 */
package mage.server;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import mage.server.AuthorizedUser;
import mage.server.DisconnectReason;
import mage.server.User;
import mage.server.managers.ManagerFactory;
import mage.server.managers.UserManager;
import mage.server.record.UserStats;
import mage.server.record.UserStatsRepository;
import mage.server.util.ServerMessagesUtil;
import mage.util.XmageThreadFactory;
import mage.view.UserView;
import org.apache.log4j.Logger;

public class UserManagerImpl
implements UserManager {
    private static final int USER_CONNECTION_TIMEOUTS_CHECK_SECS = 30;
    private static final int USER_CONNECTION_TIMEOUT_INFORM_AFTER_SECS = 30;
    private static final int USER_CONNECTION_TIMEOUT_SESSION_EXPIRE_AFTER_SECS = 180;
    private static final int USER_CONNECTION_TIMEOUT_REMOVE_FROM_SERVER_SECS = 480;
    private static final int SERVER_USERS_LIST_UPDATE_SECS = 10;
    private static final Logger logger = Logger.getLogger(UserManagerImpl.class);
    protected final ScheduledExecutorService CONNECTION_EXPIRED_EXECUTOR = Executors.newSingleThreadScheduledExecutor(new XmageThreadFactory("XMAGE connection expired check"));
    protected final ScheduledExecutorService USERS_LIST_REFRESH_EXECUTOR = Executors.newSingleThreadScheduledExecutor(new XmageThreadFactory("XMAGE users list refresh"));
    private List<UserView> userInfoList = new ArrayList<UserView>();
    private int maxUsersOnline = 0;
    private final ManagerFactory managerFactory;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final ConcurrentHashMap<UUID, User> users = new ConcurrentHashMap();
    private ExecutorService USER_EXECUTOR;

    public UserManagerImpl(ManagerFactory managerFactory) {
        this.managerFactory = managerFactory;
    }

    public void init() {
        this.USER_EXECUTOR = this.managerFactory.threadExecutor().getCallExecutor();
        this.CONNECTION_EXPIRED_EXECUTOR.scheduleAtFixedRate(this::checkExpired, 30L, 30L, TimeUnit.SECONDS);
        this.USERS_LIST_REFRESH_EXECUTOR.scheduleAtFixedRate(this::updateUserInfoList, 10L, 10L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<User> createUser(String userName, String host, AuthorizedUser authorizedUser) {
        if (this.getUserByName(userName).isPresent()) {
            return Optional.empty();
        }
        User user = new User(this.managerFactory, userName, host, authorizedUser);
        Lock w = this.lock.writeLock();
        w.lock();
        try {
            this.users.put(user.getId(), user);
        }
        finally {
            w.unlock();
        }
        return Optional.of(user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<User> getUser(UUID userId) {
        if (userId == null) {
            return Optional.empty();
        }
        Lock r = this.lock.readLock();
        r.lock();
        try {
            Optional<Object> optional = Optional.ofNullable(this.users.getOrDefault(userId, null));
            return optional;
        }
        finally {
            r.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<User> getUserByName(String userName) {
        Lock r = this.lock.readLock();
        r.lock();
        try {
            Optional<User> optional = this.users.values().stream().filter(user -> user.getName().equals(userName)).findFirst();
            return optional;
        }
        finally {
            r.unlock();
        }
    }

    @Override
    public Collection<User> getUsers() {
        ArrayList<User> userList = new ArrayList<User>();
        Lock r = this.lock.readLock();
        r.lock();
        try {
            userList.addAll(this.users.values());
        }
        finally {
            r.unlock();
        }
        return userList;
    }

    @Override
    public boolean connectToSession(String sessionId, UUID userId) {
        Optional<User> user;
        if (userId != null && (user = this.getUser(userId)).isPresent()) {
            user.get().setSessionId(sessionId);
            return true;
        }
        return false;
    }

    @Override
    public void disconnect(UUID userId, DisconnectReason reason) {
        User user = this.getUser(userId).orElse(null);
        if (user != null) {
            user.onLostConnection(reason);
        }
    }

    @Override
    public boolean isAdmin(UUID userId) {
        return this.getUser(userId).filter(u -> u.getName().equals("Admin")).isPresent();
    }

    @Override
    public void informUserOpponents(UUID userId, String message) {
        if (userId != null) {
            this.getUser(userId).ifPresent(user -> this.USER_EXECUTOR.execute(() -> {
                try {
                    this.managerFactory.chatManager().sendMessageToUserChats(user.getId(), message);
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }));
        }
    }

    @Override
    public boolean extendUserSession(UUID userId, String pingInfo) {
        User user;
        if (userId != null && (user = this.users.get(userId)) != null) {
            user.updateLastActivity(pingInfo);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkExpired() {
        try {
            Calendar calInform = Calendar.getInstance();
            calInform.add(13, -30);
            Calendar calSessionExpire = Calendar.getInstance();
            calSessionExpire.add(13, -180);
            Calendar calUserRemove = Calendar.getInstance();
            calUserRemove.add(13, -480);
            ArrayList<User> usersToRemove = new ArrayList<User>();
            logger.debug((Object)"Start Check Expired");
            ArrayList<User> userList = new ArrayList<User>();
            Lock r = this.lock.readLock();
            r.lock();
            try {
                userList.addAll(this.users.values());
            }
            finally {
                r.unlock();
            }
            block15: for (User user : userList) {
                try {
                    boolean isBadConnection = user.isExpired(calInform.getTime());
                    boolean isBadSession = user.isExpired(calSessionExpire.getTime());
                    boolean isBadUser = user.isExpired(calUserRemove.getTime());
                    switch (user.getUserState()) {
                        case Created: {
                            break;
                        }
                        case Offline: {
                            if (!isBadUser) continue block15;
                            usersToRemove.add(user);
                            break;
                        }
                        case Connected: 
                        case Disconnected: {
                            if (isBadConnection) {
                                long secsInfo = (Calendar.getInstance().getTimeInMillis() - user.getLastActivity().getTime()) / 1000L;
                                this.informUserOpponents(user.getId(), String.format("%s catch connection problems for %s secs (left before expire: %d secs)", user.getName(), secsInfo, Math.max(0L, 180L - secsInfo)));
                            }
                            if (!isBadSession) continue block15;
                            logger.info((Object)(user.getName() + " disconnected due connection problems"));
                            this.disconnect(user.getId(), DisconnectReason.SessionExpired);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown user state: " + (Object)((Object)user.getUserState()));
                        }
                    }
                }
                catch (Exception ex) {
                    this.handleException(ex);
                }
            }
            logger.debug((Object)("Users to remove " + usersToRemove.size()));
            Lock w = this.lock.writeLock();
            w.lock();
            try {
                for (User user : usersToRemove) {
                    this.users.remove(user.getId());
                }
            }
            finally {
                w.unlock();
            }
            logger.debug((Object)"End Check Expired");
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    @Override
    public void removeUser(UUID userId) {
        try {
            Lock w = this.lock.writeLock();
            w.lock();
            try {
                this.users.remove(userId);
            }
            finally {
                w.unlock();
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void updateUserInfoList() {
        try {
            ArrayList<UserView> newUserInfoList = new ArrayList<UserView>();
            int currentOnlineCount = 0;
            for (User user : this.getUsers()) {
                newUserInfoList.add(new UserView(user.getName(), user.getHost(), user.getSessionId(), user.getConnectionTime(), user.getLastActivity(), user.getGameInfo(), user.getUserState().toString(), user.getChatLockedUntil(), user.getClientVersion(), user.getEmail(), user.getUserIdStr()));
                if (!user.isOnlineUser()) continue;
                ++currentOnlineCount;
            }
            this.userInfoList = newUserInfoList;
            if (currentOnlineCount > this.maxUsersOnline) {
                this.maxUsersOnline = currentOnlineCount;
                logger.info((Object)String.format("New max users online: %d", this.maxUsersOnline));
                ServerMessagesUtil.instance.setMaxUsersOnline(this.maxUsersOnline);
            }
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    @Override
    public List<UserView> getUserInfoList() {
        return this.userInfoList;
    }

    @Override
    public void handleException(Exception ex) {
        if (ex != null) {
            logger.fatal((Object)"User manager exception ", (Throwable)ex);
            if (ex.getStackTrace() != null) {
                logger.fatal((Object)ex.getStackTrace());
            }
        } else {
            logger.fatal((Object)"User manager exception - null");
        }
    }

    @Override
    public String getUserHistory(String userName) {
        Optional<User> user = this.getUserByName(userName);
        if (user.isPresent()) {
            return "History of user " + userName + " - " + user.get().getUserData().getHistory();
        }
        UserStats userStats = UserStatsRepository.instance.getUser(userName);
        if (userStats != null) {
            return "History of user " + userName + " - " + User.userStatsToHistory(userStats.getProto());
        }
        return "User " + userName + " not found";
    }

    @Override
    public void updateUserHistory() {
        this.USER_EXECUTOR.execute(() -> {
            for (String updatedUser : UserStatsRepository.instance.updateUserStats()) {
                this.getUserByName(updatedUser).ifPresent(User::resetUserStats);
            }
        });
    }

    @Override
    public void checkHealth() {
    }
}

