/*
 * Decompiled with CFR 0.152.
 */
package mage.server.draft;

import java.rmi.RemoteException;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import mage.game.draft.Draft;
import mage.game.draft.DraftPlayer;
import mage.interfaces.callback.ClientCallback;
import mage.interfaces.callback.ClientCallbackMethod;
import mage.server.User;
import mage.server.managers.ManagerFactory;
import mage.view.DraftClientMessage;
import mage.view.DraftPickView;
import mage.view.DraftView;
import org.apache.log4j.Logger;

public class DraftSession {
    protected static final Logger logger = Logger.getLogger(DraftSession.class);
    private final ManagerFactory managerFactory;
    protected final UUID userId;
    protected final UUID playerId;
    protected final Draft draft;
    protected boolean killed = false;
    protected UUID markedCard;
    protected int timeoutCardNum;
    protected int timeoutCounter = 0;
    protected final int AUTOPICK_BUFFER = 2;
    private ScheduledFuture<?> futureTimeout;
    protected final ScheduledExecutorService timeoutExecutor;

    public DraftSession(ManagerFactory managerFactory, Draft draft, UUID userId, UUID playerId) {
        this.managerFactory = managerFactory;
        this.timeoutExecutor = managerFactory.threadExecutor().getTimeoutExecutor();
        this.userId = userId;
        this.draft = draft;
        this.playerId = playerId;
        this.markedCard = null;
    }

    public boolean init() {
        Optional<User> user;
        if (!this.killed && (user = this.managerFactory.userManager().getUser(this.userId)).isPresent()) {
            int remaining = this.futureTimeout != null && !this.futureTimeout.isDone() ? (int)this.futureTimeout.getDelay(TimeUnit.SECONDS) : this.draft.getPickTimeout();
            user.get().fireCallback(new ClientCallback(ClientCallbackMethod.DRAFT_INIT, this.draft.getId(), (Object)new DraftClientMessage(this.getDraftView(), this.getDraftPickView(remaining))));
            return true;
        }
        return false;
    }

    public void update() {
        if (!this.killed) {
            this.managerFactory.userManager().getUser(this.userId).ifPresent(user -> user.fireCallback(new ClientCallback(ClientCallbackMethod.DRAFT_UPDATE, this.draft.getId(), (Object)new DraftClientMessage(this.getDraftView(), null))));
        }
    }

    public void draftOver() {
        if (!this.killed) {
            this.managerFactory.userManager().getUser(this.userId).ifPresent(user -> user.fireCallback(new ClientCallback(ClientCallbackMethod.DRAFT_OVER, this.draft.getId())));
        }
    }

    public void pickCard(int timeout) {
        if (!this.killed) {
            this.setupTimeout(timeout);
            this.timeoutCardNum = this.draft.getCardNum();
            this.managerFactory.userManager().getUser(this.userId).ifPresent(user -> user.fireCallback(new ClientCallback(ClientCallbackMethod.DRAFT_PICK, this.draft.getId(), (Object)new DraftClientMessage(this.getDraftView(), this.getDraftPickView(timeout)))));
        }
    }

    private synchronized void setupTimeout(int seconds) {
        this.cancelTimeout();
        if (seconds > 0) {
            if (seconds > 1) {
                this.timeoutCounter = 0;
            }
            this.futureTimeout = this.timeoutExecutor.schedule(() -> {
                try {
                    if (this.timeoutCardNum == this.draft.getCardNum()) {
                        if (this.timeoutCounter++ > 2) {
                            this.managerFactory.draftManager().timeout(this.draft.getId(), this.userId);
                        }
                        this.setupTimeout(1);
                    }
                }
                catch (Exception e) {
                    logger.fatal((Object)("DraftSession error - userId " + this.userId + " draftId " + this.draft.getId()), (Throwable)e);
                }
            }, (long)seconds, TimeUnit.SECONDS);
        }
    }

    private synchronized void cancelTimeout() {
        if (this.futureTimeout != null) {
            this.futureTimeout.cancel(false);
        }
    }

    protected void handleRemoteException(RemoteException ex) {
        logger.fatal((Object)"DraftSession error ", (Throwable)ex);
        this.managerFactory.draftManager().kill(this.draft.getId(), this.userId);
    }

    public void setKilled() {
        this.killed = true;
    }

    public DraftPickView sendCardPick(UUID cardId, Set<UUID> hiddenCards) {
        if (this.draft.addPick(this.playerId, cardId, hiddenCards)) {
            return this.getDraftPickView(0);
        }
        return null;
    }

    public void removeDraft() {
        this.managerFactory.userManager().getUser(this.userId).ifPresent(user -> user.removeDraft(this.playerId));
    }

    private DraftView getDraftView() {
        return new DraftView(this.draft);
    }

    private DraftPickView getDraftPickView(int timeout) {
        return new DraftPickView(this.draft.getPlayer(this.playerId), timeout);
    }

    public DraftPlayer getDraftPlayer() {
        return this.draft.getPlayer(this.playerId);
    }

    public Draft getDraft() {
        return this.draft;
    }

    public UUID getMarkedCard() {
        return this.markedCard;
    }

    public void setMarkedCard(UUID markedCard) {
        this.markedCard = markedCard;
    }

    public void setBoosterLoaded() {
        this.draft.setBoosterLoaded(this.playerId);
    }
}

