/*
 * Decompiled with CFR 0.152.
 */
package mage.server.game;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import mage.MageException;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.cards.Cards;
import mage.choices.Choice;
import mage.constants.ManaType;
import mage.constants.PlayerAction;
import mage.game.Game;
import mage.game.GameOptions;
import mage.game.GameState;
import mage.game.Table;
import mage.game.command.Plane;
import mage.game.match.MatchPlayer;
import mage.game.permanent.Permanent;
import mage.game.turn.Phase;
import mage.interfaces.Action;
import mage.players.Player;
import mage.server.Main;
import mage.server.User;
import mage.server.game.GameCallback;
import mage.server.game.GameSessionPlayer;
import mage.server.game.GameSessionWatcher;
import mage.server.game.GameWorker;
import mage.server.managers.ManagerFactory;
import mage.util.MultiAmountMessage;
import mage.util.XmageThreadFactory;
import mage.utils.StreamUtils;
import mage.utils.timer.PriorityTimer;
import mage.view.AbilityPickerView;
import mage.view.CardsView;
import mage.view.ChatMessage;
import mage.view.GameView;
import mage.view.PermanentView;
import org.apache.log4j.Logger;

public class GameController
implements GameCallback {
    private static final int GAME_TIMEOUTS_CHECK_JOINING_STATUS_EVERY_SECS = 10;
    private static final int GAME_TIMEOUTS_CANCEL_PLAYER_GAME_JOINING_AFTER_INACTIVE_SECS = 120;
    private final ExecutorService gameExecutor;
    private static final Logger logger = Logger.getLogger(GameController.class);
    private ScheduledExecutorService JOIN_WAITING_EXECUTOR = null;
    private ScheduledFuture<?> responseIdleTimeoutFuture;
    private UUID responseIdleTimeoutPlayerId;
    private final ManagerFactory managerFactory;
    protected final ScheduledExecutorService responseIdleTimeoutExecutor;
    private final ConcurrentMap<UUID, GameSessionPlayer> gameSessions = new ConcurrentHashMap<UUID, GameSessionPlayer>();
    private final ReadWriteLock gameSessionsLock = new ReentrantReadWriteLock();
    private final ConcurrentMap<UUID, GameSessionWatcher> watchers = new ConcurrentHashMap<UUID, GameSessionWatcher>();
    private final ReadWriteLock gameWatchersLock = new ReentrantReadWriteLock();
    private final ConcurrentMap<UUID, PriorityTimer> timers = new ConcurrentHashMap<UUID, PriorityTimer>();
    private final ConcurrentMap<UUID, UUID> userPlayerMap;
    private final UUID gameSessionId;
    private final Game game;
    private final UUID chatId;
    private final UUID tableId;
    private final UUID choosingPlayerId;
    private Future<?> gameFuture;
    private boolean useResponseIdleTimeout = true;
    private final GameOptions gameOptions;
    private UUID userRequestingRollback;
    private int turnsToRollback;
    private int requestsOpen;

    public GameController(ManagerFactory managerFactory, Game game, ConcurrentMap<UUID, UUID> userPlayerMap, UUID tableId, UUID choosingPlayerId, GameOptions gameOptions) {
        this.managerFactory = managerFactory;
        this.gameExecutor = managerFactory.threadExecutor().getGameExecutor();
        this.responseIdleTimeoutExecutor = managerFactory.threadExecutor().getTimeoutIdleExecutor();
        this.gameSessionId = UUID.randomUUID();
        this.userPlayerMap = userPlayerMap;
        this.chatId = managerFactory.chatManager().createGameChatSession(game);
        this.userRequestingRollback = null;
        this.game = game;
        this.game.setSaveGame(managerFactory.configSettings().isSaveGameActivated());
        this.tableId = tableId;
        this.choosingPlayerId = choosingPlayerId;
        this.gameOptions = gameOptions;
        this.useResponseIdleTimeout = game.getPlayers().values().stream().filter(Player::isHuman).count() > 1L;
        this.init();
    }

    public void cleanUp() {
        this.stopResponseIdleTimeout();
        for (PriorityTimer priorityTimer : this.timers.values()) {
            priorityTimer.cancel();
        }
        this.getGameSessions().forEach(GameSessionPlayer::cleanUp);
        this.getGameSessionWatchers().forEach(GameSessionWatcher::cleanUp);
        this.managerFactory.chatManager().destroyChatSession(this.chatId);
    }

    private void init() {
        this.game.addTableEventListener(event -> {
            try {
                switch (event.getEventType()) {
                    case UPDATE: {
                        this.updateGame();
                        break;
                    }
                    case INFO: {
                        this.managerFactory.chatManager().broadcast(this.chatId, "", event.getMessage(), ChatMessage.MessageColor.BLACK, true, event.getGame(), ChatMessage.MessageType.GAME, null);
                        logger.trace((Object)(this.game.getId() + " " + event.getMessage()));
                        break;
                    }
                    case STATUS: {
                        this.managerFactory.chatManager().broadcast(this.chatId, "", event.getMessage(), ChatMessage.MessageColor.ORANGE, event.getWithTime(), event.getWithTurnInfo() ? event.getGame() : null, ChatMessage.MessageType.GAME, null);
                        logger.trace((Object)(this.game.getId() + " " + event.getMessage()));
                        break;
                    }
                    case ERROR: {
                        this.error(event.getMessage(), event.getException());
                        break;
                    }
                    case END_GAME_INFO: {
                        this.endGameInfo();
                        break;
                    }
                    case INIT_TIMER: {
                        UUID initPlayerId = event.getPlayerId();
                        if (initPlayerId == null) {
                            throw new MageException("INIT_TIMER: playerId can't be null");
                        }
                        this.createPlayerTimer(event.getPlayerId(), this.game.getPriorityTime());
                        break;
                    }
                    case RESUME_TIMER: {
                        UUID playerId = event.getPlayerId();
                        if (playerId == null) {
                            throw new MageException("RESUME_TIMER: playerId can't be null");
                        }
                        Player player = this.game.getState().getPlayer(playerId);
                        if (player == null) {
                            throw new MageException("RESUME_TIMER: player can't be null");
                        }
                        PriorityTimer timer = (PriorityTimer)this.timers.get(playerId);
                        if (timer == null) {
                            timer = this.createPlayerTimer(event.getPlayerId(), player.getPriorityTimeLeft());
                        }
                        player.setBufferTimeLeft(this.game.getBufferTime());
                        timer.setBufferCount(this.game.getBufferTime());
                        timer.resume();
                        break;
                    }
                    case PAUSE_TIMER: {
                        UUID playerId = event.getPlayerId();
                        if (playerId == null) {
                            throw new MageException("PAUSE_TIMER: playerId can't be null");
                        }
                        PriorityTimer timer = (PriorityTimer)this.timers.get(playerId);
                        if (timer == null) {
                            throw new MageException("PAUSE_TIMER: couldn't find timer for player: " + playerId);
                        }
                        timer.pause();
                    }
                }
            }
            catch (MageException e) {
                logger.fatal((Object)("Table event listener error: " + e), (Throwable)e);
            }
        });
        this.game.addPlayerQueryEventListener(event -> {
            logger.trace((Object)(event.getPlayerId().toString() + "--" + (Object)((Object)event.getQueryType()) + "--" + event.getMessage()));
            try {
                switch (event.getQueryType()) {
                    case ASK: {
                        this.ask(event.getPlayerId(), event.getMessage(), event.getOptions());
                        break;
                    }
                    case PICK_TARGET: {
                        this.target(event.getPlayerId(), event.getMessage(), event.getCards(), event.getPerms(), event.getTargets(), event.isRequired(), event.getOptions());
                        break;
                    }
                    case PICK_ABILITY: {
                        this.target(event.getPlayerId(), event.getMessage(), event.getAbilities(), event.isRequired(), event.getOptions());
                        break;
                    }
                    case SELECT: {
                        this.select(event.getPlayerId(), event.getMessage(), event.getOptions());
                        break;
                    }
                    case PLAY_MANA: {
                        this.playMana(event.getPlayerId(), event.getMessage(), event.getOptions());
                        break;
                    }
                    case PLAY_X_MANA: {
                        this.playXMana(event.getPlayerId(), event.getMessage());
                        break;
                    }
                    case CHOOSE_ABILITY: {
                        String objectName = null;
                        if (event.getChoices() != null && !event.getChoices().isEmpty()) {
                            objectName = event.getChoices().iterator().next();
                        }
                        this.chooseAbility(event.getPlayerId(), objectName, event.getAbilities(), event.getMessage());
                        break;
                    }
                    case CHOOSE_PILE: {
                        this.choosePile(event.getPlayerId(), event.getMessage(), event.getPile1(), event.getPile2());
                        break;
                    }
                    case CHOOSE_MODE: {
                        this.chooseMode(event.getPlayerId(), event.getModes(), event.getMessage());
                        break;
                    }
                    case CHOOSE_CHOICE: {
                        this.chooseChoice(event.getPlayerId(), event.getChoice());
                        break;
                    }
                    case AMOUNT: {
                        this.amount(event.getPlayerId(), event.getMessage(), event.getMin(), event.getMax());
                        break;
                    }
                    case MULTI_AMOUNT: {
                        this.multiAmount(event.getPlayerId(), event.getMessages(), event.getMin(), event.getMax(), event.getOptions());
                        break;
                    }
                    case PERSONAL_MESSAGE: {
                        this.informPersonal(event.getPlayerId(), event.getMessage());
                        break;
                    }
                    case TOURNAMENT_CONSTRUCT: 
                    case DRAFT_PICK_CARD: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown game event: " + (Object)((Object)event.getQueryType()));
                    }
                }
            }
            catch (MageException ex) {
                logger.fatal((Object)"Player event listener error ", (Throwable)ex);
            }
        });
        if (this.JOIN_WAITING_EXECUTOR == null) {
            this.JOIN_WAITING_EXECUTOR = Executors.newSingleThreadScheduledExecutor(new XmageThreadFactory("XMAGE game join waiting " + this.game.getId()));
        }
        this.JOIN_WAITING_EXECUTOR.scheduleAtFixedRate(() -> {
            try {
                this.sendInfoAboutPlayersNotJoinedYetAndTryToFixIt();
            }
            catch (Exception ex) {
                logger.fatal((Object)"Send info about player not joined yet:", (Throwable)ex);
            }
        }, 10L, 10L, TimeUnit.SECONDS);
        this.checkJoinAndStart();
    }

    private PriorityTimer createPlayerTimer(UUID playerId, int count) {
        UUID initPlayerId = playerId;
        long delayMs = 250L;
        Action executeOnNoTimeLeft = () -> {
            this.game.timerTimeout(initPlayerId);
            logger.debug((Object)("Player has no time left to end the match: " + initPlayerId + ". Conceding."));
        };
        PriorityTimer timer = new PriorityTimer(count, delayMs, executeOnNoTimeLeft);
        timer.init(this.game.getId());
        this.timers.put(playerId, timer);
        return timer;
    }

    private UUID getPlayerId(UUID userId) {
        return (UUID)this.userPlayerMap.get(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join(UUID userId) {
        String joinType;
        UUID playerId = (UUID)this.userPlayerMap.get(userId);
        if (playerId == null) {
            logger.fatal((Object)"Join game failed!");
            logger.fatal((Object)("- gameId: " + this.game.getId()));
            logger.fatal((Object)("- userId: " + userId));
            return;
        }
        Optional<User> user = this.managerFactory.userManager().getUser(userId);
        if (!user.isPresent()) {
            logger.fatal((Object)("User not found : " + userId));
            return;
        }
        Player player = this.game.getPlayer(playerId);
        if (player == null) {
            logger.fatal((Object)("Player not found - playerId: " + playerId));
            return;
        }
        GameSessionPlayer gameSession = (GameSessionPlayer)this.gameSessions.get(playerId);
        if (gameSession == null) {
            gameSession = new GameSessionPlayer(this.managerFactory, this.game, userId, playerId);
            Lock w = this.gameSessionsLock.writeLock();
            w.lock();
            try {
                this.gameSessions.put(playerId, gameSession);
            }
            finally {
                w.unlock();
            }
            joinType = "joined";
        } else {
            joinType = "rejoined";
        }
        user.get().addGame(playerId, gameSession);
        logger.debug((Object)("Player " + player.getName() + ' ' + playerId + " has " + joinType + " gameId: " + this.game.getId()));
        this.managerFactory.chatManager().broadcast(this.chatId, "", this.game.getPlayer(playerId).getLogName() + " has " + joinType + " the game", ChatMessage.MessageColor.ORANGE, true, this.game, ChatMessage.MessageType.GAME, null);
        this.checkJoinAndStart();
    }

    private synchronized void startGame() {
        if (this.gameFuture == null) {
            for (Player player : this.game.getPlayers().values()) {
                player.updateRange(this.game);
            }
            for (GameSessionPlayer gameSessionPlayer : this.getGameSessions()) {
                gameSessionPlayer.init();
            }
            GameWorker worker = new GameWorker(this.game, this.choosingPlayerId, this);
            this.gameFuture = this.gameExecutor.submit(worker);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.game.getState().getChoosingPlayerId() != null) {
                this.startResponseIdleTimeout(this.game.getState().getChoosingPlayerId());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void sendInfoAboutPlayersNotJoinedYetAndTryToFixIt() {
        for (Player player : this.game.getPlayers().values()) {
            if (!player.canRespond() || !player.isHuman()) continue;
            Optional<User> requestedUser = this.getUserByPlayerId(player.getId());
            if (requestedUser.isPresent()) {
                User user = requestedUser.get();
                if (this.gameSessions.get(player.getId()) == null) {
                    String problemPlayerFixes;
                    user.removeConstructing(player.getId());
                    this.managerFactory.gameManager().joinGame(this.game.getId(), user.getId());
                    logger.warn((Object)("Forced join of player " + player.getName() + " (" + (Object)((Object)user.getUserState()) + ") to gameId: " + this.game.getId()));
                    if (user.isConnected()) {
                        GameSessionPlayer session = (GameSessionPlayer)this.gameSessions.get(player.getId());
                        if (session == null) throw new IllegalStateException("Wrong code usage: session can't be null cause it created in forced joinGame already");
                        problemPlayerFixes = "re-send start game event";
                        logger.warn((Object)("Send forced game start event for player " + player.getName() + " in gameId: " + this.game.getId()));
                        Table table = this.managerFactory.tableManager().getTable(this.tableId);
                        if (table != null) {
                            user.ccGameStarted(table.getId(), table.getParentTableId(), session.getGameId(), player.getId());
                            session.init();
                            this.managerFactory.gameManager().sendPlayerString(session.getGameId(), user.getId(), "");
                        } else {
                            logger.error((Object)("Can't find table on fix and re-send start game event: " + this.tableId));
                        }
                    } else {
                        problemPlayerFixes = "leave on disconnected";
                        logger.warn((Object)("User disconnected, leave him after forced join: player " + player.getName() + " in gameId: " + this.game.getId()));
                        player.leave();
                    }
                    this.managerFactory.chatManager().broadcast(this.chatId, player.getName(), user.getPingInfo() + " is forced to join the game (waiting ends after " + 120 + " secs, applied fixes: " + problemPlayerFixes + ")", ChatMessage.MessageColor.BLUE, true, this.game, ChatMessage.MessageType.STATUS, null);
                }
                if (user.isConnected() || user.getSecondsDisconnected() <= 120L) continue;
                logger.debug((Object)("Player " + player.getName() + " - canceled joining game (after " + user.getSecondsDisconnected() + " secs of inactivity) gameId: " + this.game.getId()));
                player.leave();
                continue;
            }
            if (player.hasLeft()) continue;
            logger.debug((Object)("Player " + player.getName() + " canceled game (no user) gameId: " + this.game.getId()));
            player.leave();
        }
        this.checkJoinAndStart();
    }

    private Optional<User> getUserByPlayerId(UUID playerId) {
        for (Map.Entry entry : this.userPlayerMap.entrySet()) {
            if (!((UUID)entry.getValue()).equals(playerId)) continue;
            return this.managerFactory.userManager().getUser((UUID)entry.getKey());
        }
        return Optional.empty();
    }

    private void checkJoinAndStart() {
        if (this.isAllJoined()) {
            this.JOIN_WAITING_EXECUTOR.shutdownNow();
            this.managerFactory.threadExecutor().getCallExecutor().execute(this::startGame);
        }
    }

    private boolean isAllJoined() {
        for (Player player : this.game.getPlayers().values()) {
            if (player.hasLeft()) continue;
            Optional<User> user = this.getUserByPlayerId(player.getId());
            if (user.isPresent() && !user.get().isConnected()) {
                return false;
            }
            if (!player.isHuman() || this.gameSessions.containsKey(player.getId())) continue;
            return false;
        }
        return true;
    }

    public boolean watch(UUID userId) {
        if (this.userPlayerMap.containsKey(userId)) {
            return false;
        }
        if (this.watchers.containsKey(userId)) {
            return false;
        }
        if (!this.isAllowedToWatch(userId)) {
            this.managerFactory.userManager().getUser(userId).ifPresent(user -> {
                user.showUserMessage("Not allowed", "You are banned from watching this game");
                this.managerFactory.chatManager().broadcast(this.chatId, user.getName(), " tried to join, but is banned", ChatMessage.MessageColor.BLUE, true, this.game, ChatMessage.MessageType.STATUS, null);
            });
            return false;
        }
        this.managerFactory.userManager().getUser(userId).ifPresent(user -> {
            GameSessionWatcher gameWatcher = new GameSessionWatcher(this.managerFactory.userManager(), userId, this.game, false);
            Lock w = this.gameWatchersLock.writeLock();
            w.lock();
            try {
                this.watchers.put(userId, gameWatcher);
            }
            finally {
                w.unlock();
            }
            gameWatcher.init();
            user.addGameWatchInfo(this.game.getId());
            this.managerFactory.chatManager().broadcast(this.chatId, user.getName(), " has started watching", ChatMessage.MessageColor.BLUE, true, this.game, ChatMessage.MessageType.STATUS, null);
        });
        return true;
    }

    public void stopWatching(UUID userId) {
        Lock w = this.gameWatchersLock.writeLock();
        w.lock();
        try {
            this.watchers.remove(userId);
        }
        finally {
            w.unlock();
        }
        this.managerFactory.userManager().getUser(userId).ifPresent(user -> this.managerFactory.chatManager().broadcast(this.chatId, user.getName(), " has stopped watching", ChatMessage.MessageColor.BLUE, true, this.game, ChatMessage.MessageType.STATUS, null));
    }

    public void quitMatch(UUID userId) {
        UUID playerId = this.getPlayerId(userId);
        if (playerId != null) {
            if (this.isAllJoined()) {
                GameSessionPlayer gameSessionPlayer = (GameSessionPlayer)this.gameSessions.get(playerId);
                if (gameSessionPlayer != null) {
                    gameSessionPlayer.quitGame();
                }
            } else {
                Player player = this.game.getPlayer(playerId);
                if (player != null) {
                    player.leave();
                    this.checkJoinAndStart();
                }
            }
        }
    }

    public void sendPlayerAction(PlayerAction playerAction, UUID userId, Object data) {
        switch (playerAction) {
            case UNDO: {
                this.game.undo(this.getPlayerId(userId));
                break;
            }
            case ROLLBACK_TURNS: {
                Player player;
                if (!(data instanceof Integer)) break;
                this.turnsToRollback = (Integer)data;
                if (this.game.canRollbackTurns(this.turnsToRollback)) {
                    UUID playerId = this.getPlayerId(userId);
                    if (this.game.getPriorityPlayerId().equals(playerId)) {
                        this.requestsOpen = this.requestPermissionToRollback(userId, this.turnsToRollback);
                        if (this.requestsOpen == 0) {
                            this.game.rollbackTurns(this.turnsToRollback);
                            this.turnsToRollback = -1;
                            this.requestsOpen = -1;
                            break;
                        }
                        this.userRequestingRollback = userId;
                        break;
                    }
                    Player player2 = this.game.getPlayer(playerId);
                    if (player2 == null) break;
                    this.game.informPlayer(player2, "You can only request a rollback if you have priority.");
                    break;
                }
                UUID playerId = this.getPlayerId(userId);
                if (playerId == null || (player = this.game.getPlayer(playerId)) == null) break;
                this.game.informPlayer(player, "That turn is not available for rollback.");
                break;
            }
            case ADD_PERMISSION_TO_ROLLBACK_TURN: {
                if (this.userRequestingRollback == null || this.requestsOpen <= 0 || userId.equals(this.userRequestingRollback)) break;
                --this.requestsOpen;
                if (this.requestsOpen != 0) break;
                this.game.rollbackTurns(this.turnsToRollback);
                this.turnsToRollback = -1;
                this.userRequestingRollback = null;
                this.requestsOpen = -1;
                break;
            }
            case DENY_PERMISSION_TO_ROLLBACK_TURN: {
                Player player;
                UUID playerId = this.getPlayerId(userId);
                if (playerId == null || (player = this.game.getPlayer(playerId)) == null || this.userRequestingRollback == null || this.requestsOpen <= 0 || userId.equals(this.userRequestingRollback)) break;
                this.turnsToRollback = -1;
                this.userRequestingRollback = null;
                this.requestsOpen = -1;
                this.game.informPlayers("Rollback request denied by " + player.getLogName());
                break;
            }
            case CONCEDE: {
                Player player;
                UUID playerId = this.getPlayerId(userId);
                if (playerId == null || (player = this.game.getPlayer(playerId)) == null) break;
                this.game.informPlayers(player.getLogName() + " wants to concede");
                this.game.setConcedingPlayer(this.getPlayerId(userId));
                break;
            }
            case MANA_AUTO_PAYMENT_OFF: {
                this.game.setManaPaymentMode(this.getPlayerId(userId), false);
                break;
            }
            case MANA_AUTO_PAYMENT_ON: {
                this.game.setManaPaymentMode(this.getPlayerId(userId), true);
                break;
            }
            case MANA_AUTO_PAYMENT_RESTRICTED_OFF: {
                this.game.setManaPaymentModeRestricted(this.getPlayerId(userId), false);
                break;
            }
            case MANA_AUTO_PAYMENT_RESTRICTED_ON: {
                this.game.setManaPaymentModeRestricted(this.getPlayerId(userId), true);
                break;
            }
            case USE_FIRST_MANA_ABILITY_ON: {
                this.game.setUseFirstManaAbility(this.getPlayerId(userId), true);
                break;
            }
            case USE_FIRST_MANA_ABILITY_OFF: {
                this.game.setUseFirstManaAbility(this.getPlayerId(userId), false);
                break;
            }
            case ADD_PERMISSION_TO_SEE_HAND_CARDS: {
                Player player;
                UUID playerId;
                if (!(data instanceof UUID) || (playerId = this.getPlayerId(userId)) == null || (player = this.game.getPlayer(playerId)) == null) break;
                player.addPermissionToShowHandCards((UUID)data);
                break;
            }
            case REVOKE_PERMISSIONS_TO_SEE_HAND_CARDS: {
                Player player;
                UUID playerId = this.getPlayerId(userId);
                if (playerId == null || (player = this.game.getPlayer(playerId)) == null) break;
                player.revokePermissionToSeeHandCards();
                break;
            }
            case REQUEST_PERMISSION_TO_SEE_HAND_CARDS: {
                if (!(data instanceof UUID)) break;
                this.requestPermissionToSeeHandCards(userId, (UUID)data);
                break;
            }
            case VIEW_LIMITED_DECK: {
                if (!(data instanceof UUID)) break;
                UUID targetPlayerId = (UUID)data;
                this.viewDeckOrSideboard(this.getPlayerId(userId), userId, targetPlayerId, false);
                break;
            }
            case VIEW_SIDEBOARD: {
                if (!(data instanceof UUID)) break;
                UUID targetPlayerId = (UUID)data;
                this.viewDeckOrSideboard(this.getPlayerId(userId), userId, targetPlayerId, true);
                break;
            }
            default: {
                this.game.sendPlayerAction(playerAction, this.getPlayerId(userId), data);
            }
        }
    }

    private int requestPermissionToRollback(UUID userIdRequester, int numberTurns) {
        int requests = 0;
        for (Player player : this.game.getState().getPlayers().values()) {
            Optional<User> requestedUser = this.getUserByPlayerId(player.getId());
            if (!player.isInGame() || !player.isHuman() || !requestedUser.isPresent() || requestedUser.get().getId().equals(userIdRequester)) continue;
            ++requests;
            GameSessionPlayer gameSession = (GameSessionPlayer)this.gameSessions.get(player.getId());
            if (gameSession == null) continue;
            gameSession.requestPermissionToRollbackTurn(userIdRequester, numberTurns);
        }
        return requests;
    }

    private void requestPermissionToSeeHandCards(UUID userIdRequester, UUID userIdGranter) {
        Player grantingPlayer = this.game.getPlayer(userIdGranter);
        if (grantingPlayer != null) {
            if (!grantingPlayer.getUsersAllowedToSeeHandCards().contains(userIdRequester)) {
                if (grantingPlayer.isHuman()) {
                    UUID requestingPlayerId;
                    GameSessionPlayer gameSession = (GameSessionPlayer)this.gameSessions.get(userIdGranter);
                    if (!(gameSession == null || (requestingPlayerId = this.getPlayerId(userIdRequester)) != null && requestingPlayerId.equals(grantingPlayer.getId()))) {
                        if (grantingPlayer.isPlayerAllowedToRequestHand(this.game.getId(), requestingPlayerId)) {
                            grantingPlayer.addPlayerToRequestedHandList(this.game.getId(), requestingPlayerId);
                            gameSession.requestPermissionToSeeHandCards(userIdRequester);
                        } else {
                            this.managerFactory.userManager().getUser(userIdRequester).ifPresent(requester -> requester.showUserMessage("Request to show hand cards", "Player " + grantingPlayer.getName() + " does not allow to request to show hand cards!"));
                        }
                    }
                } else {
                    grantingPlayer.addPermissionToShowHandCards(userIdRequester);
                }
            } else {
                this.managerFactory.userManager().getUser(userIdRequester).ifPresent(requester -> requester.showUserMessage("Request to show hand cards", "You can see already the hand cards of player " + grantingPlayer.getName() + '!'));
            }
        }
    }

    private void viewDeckOrSideboard(UUID playerId, UUID userId, UUID targetPlayerId, boolean isSideboardOnly) {
        Player requestPlayer = this.game.getPlayer(playerId);
        Player targetPlayer = this.game.getPlayer(targetPlayerId);
        if (requestPlayer == null || targetPlayer == null) {
            return;
        }
        if (!requestPlayer.getId().equals(targetPlayer.getId()) && !targetPlayer.isComputer()) {
            logger.error((Object)("Player " + requestPlayer.getName() + " trying to cheat with deck/sideboard view"));
            return;
        }
        User user = this.managerFactory.userManager().getUser(userId).orElse(null);
        Table table = this.managerFactory.tableManager().getTable(this.tableId);
        if (user == null || table == null) {
            return;
        }
        MatchPlayer deckSource = table.getMatch().getPlayer(targetPlayerId);
        if (deckSource == null) {
            return;
        }
        if (isSideboardOnly) {
            user.ccViewSideboard(table.getId(), this.game.getId(), targetPlayerId);
        } else {
            user.ccViewLimitedDeck(deckSource.getDeckForViewer(), table.getId(), table.getParentTableId(), this.requestsOpen, true);
        }
    }

    public void cheatShow(UUID playerId) {
        Player player = this.game.getPlayer(playerId);
        if (player != null) {
            player.signalPlayerCheat();
        }
    }

    public void onResponseIdleTimeout(UUID playerId) {
        Player player = this.game.getPlayer(playerId);
        if (player != null) {
            String sb = player.getLogName() + " has timed out (player had priority and was not active for " + this.getResponseIdleTimeoutSecs() + " seconds ) - Auto concede.";
            this.managerFactory.chatManager().broadcast(this.chatId, "", sb, ChatMessage.MessageColor.BLACK, true, this.game, ChatMessage.MessageType.STATUS, null);
            this.game.idleTimeout(playerId);
        }
    }

    public void endGame(String message) throws MageException {
        for (GameSessionPlayer gameSession : this.getGameSessions()) {
            gameSession.gameOver(message);
            gameSession.removeGame();
        }
        for (GameSessionWatcher gameWatcher : this.getGameSessionWatchers()) {
            gameWatcher.gameOver(message);
        }
        this.managerFactory.tableManager().endGame(this.tableId);
    }

    public UUID getSessionId() {
        return this.gameSessionId;
    }

    public UUID getChatId() {
        return this.chatId;
    }

    public void sendPlayerUUID(UUID userId, UUID data) {
        this.sendMessage(userId, playerId -> this.sendDirectPlayerUUID(playerId, data));
    }

    public void sendPlayerString(UUID userId, String data) {
        this.sendMessage(userId, playerId -> this.sendDirectPlayerString(playerId, data));
    }

    public void sendPlayerManaType(UUID userId, UUID manaTypePlayerId, ManaType data) {
        this.sendMessage(userId, playerId -> this.sendDirectPlayerManaType(playerId, manaTypePlayerId, data));
    }

    public void sendPlayerBoolean(UUID userId, Boolean data) {
        this.sendMessage(userId, playerId -> this.sendDirectPlayerBoolean(playerId, data));
    }

    public void sendPlayerInteger(UUID userId, Integer data) {
        this.sendMessage(userId, playerId -> this.sendDirectPlayerInteger(playerId, data));
    }

    private void updatePriorityTimers() {
        if (!this.timers.isEmpty()) {
            for (Player player : this.game.getState().getPlayers().values()) {
                PriorityTimer timer = (PriorityTimer)this.timers.get(player.getId());
                if (timer == null) continue;
                player.setPriorityTimeLeft(timer.getCount());
            }
        }
    }

    private synchronized void updateGame() {
        this.updatePriorityTimers();
        for (GameSessionPlayer gameSession : this.getGameSessions()) {
            gameSession.update();
        }
        for (GameSessionWatcher gameWatcher : this.getGameSessionWatchers()) {
            gameWatcher.update();
        }
    }

    private synchronized void endGameInfo() {
        Table table = this.managerFactory.tableManager().getTable(this.tableId);
        if (table != null && table.getMatch() != null) {
            for (GameSessionPlayer gameSession : this.getGameSessions()) {
                gameSession.endGameInfo(table);
            }
        }
    }

    private synchronized void ask(UUID playerId, String question, Map<String, Serializable> options) throws MageException {
        this.perform(playerId, playerId1 -> this.getGameSession(playerId1).ask(question, options));
    }

    private synchronized void chooseAbility(UUID playerId, String objectName, List<? extends Ability> choices, String message) throws MageException {
        this.perform(playerId, playerId1 -> this.getGameSession(playerId1).chooseAbility(new AbilityPickerView(this.getGameView(playerId), objectName, choices, message)));
    }

    private synchronized void choosePile(UUID playerId, String message, List<? extends Card> pile1, List<? extends Card> pile2) throws MageException {
        this.perform(playerId, playerId1 -> this.getGameSession(playerId1).choosePile(message, new CardsView(this.game, (Collection)pile1, playerId), new CardsView(this.game, (Collection)pile2, playerId)));
    }

    private synchronized void chooseMode(UUID playerId, Map<UUID, String> modes, String message) throws MageException {
        this.perform(playerId, playerId1 -> this.getGameSession(playerId1).chooseAbility(new AbilityPickerView(this.getGameView(playerId), modes, message)));
    }

    private synchronized void chooseChoice(UUID playerId, Choice choice) throws MageException {
        this.perform(playerId, playerId1 -> this.getGameSession(playerId1).chooseChoice(choice));
    }

    private synchronized void target(UUID playerId, String question, Cards cards, List<Permanent> perms, Set<UUID> targets, boolean required, Map<String, Serializable> options) throws MageException {
        this.perform(playerId, playerId1 -> {
            if (cards != null) {
                this.getGameSession(playerId1).target(question, new CardsView(this.game, cards.getCards(this.game), playerId, true), targets, required, options);
            } else if (perms != null) {
                CardsView permsView = new CardsView();
                for (Permanent perm : perms) {
                    permsView.put((Object)perm.getId(), (Object)new PermanentView(perm, this.game.getCard(perm.getId()), playerId1, this.game));
                }
                this.getGameSession(playerId1).target(question, permsView, targets, required, options);
            } else {
                this.getGameSession(playerId1).target(question, new CardsView(), targets, required, options);
            }
        });
    }

    private synchronized void target(UUID playerId, String question, Collection<? extends Ability> abilities, boolean required, Map<String, Serializable> options) throws MageException {
        this.perform(playerId, playerId1 -> {
            CardsView cardsView = new CardsView(abilities, this.game);
            this.getGameSession(playerId1).target(question, cardsView, null, required, options);
        });
    }

    private synchronized void select(UUID playerId, String message, Map<String, Serializable> options) throws MageException {
        this.perform(playerId, playerId1 -> this.getGameSession(playerId1).select(message, options));
    }

    private synchronized void playMana(UUID playerId, String message, Map<String, Serializable> options) throws MageException {
        this.perform(playerId, playerId1 -> this.getGameSession(playerId1).playMana(message, options));
    }

    private synchronized void playXMana(UUID playerId, String message) throws MageException {
        this.perform(playerId, playerId1 -> this.getGameSession(playerId1).playXMana(message));
    }

    private synchronized void amount(UUID playerId, String message, int min, int max) throws MageException {
        this.perform(playerId, playerId1 -> this.getGameSession(playerId1).getAmount(message, min, max));
    }

    private synchronized void multiAmount(UUID playerId, List<MultiAmountMessage> messages, int min, int max, Map<String, Serializable> options) throws MageException {
        this.perform(playerId, playerId1 -> this.getGameSession(playerId1).getMultiAmount(messages, min, max, options));
    }

    private void informOthers(UUID waitingPlayerId) {
        StringBuilder message = new StringBuilder();
        if (this.game.getStep() != null) {
            message.append(this.game.getTurnStepType().toString()).append(" - ");
        }
        message.append("Waiting for ").append(this.game.getPlayer(waitingPlayerId).getLogName());
        for (Map.Entry<UUID, GameSessionPlayer> entry : this.getGameSessionsMap().entrySet()) {
            if (entry.getKey().equals(waitingPlayerId)) continue;
            entry.getValue().inform(message.toString());
        }
        for (GameSessionWatcher watcher : this.getGameSessionWatchers()) {
            watcher.inform(message.toString());
        }
    }

    private void informOthers(List<UUID> players) {
        Player controller = null;
        if (players != null && !players.isEmpty()) {
            controller = this.game.getPlayer(players.get(0));
        }
        if (controller == null || this.game.getStep() == null || this.game.getTurnStepType() == null) {
            return;
        }
        String message = this.game.getTurnStepType().toString() + " - Waiting for " + controller.getName();
        for (Map.Entry<UUID, GameSessionPlayer> entry : this.getGameSessionsMap().entrySet()) {
            boolean skip = players.stream().anyMatch(playerId -> ((UUID)entry.getKey()).equals(playerId));
            if (skip) continue;
            entry.getValue().inform(message);
        }
        for (GameSessionWatcher watcher : this.getGameSessionWatchers()) {
            watcher.inform(message);
        }
    }

    private void informPersonal(UUID playerId, String message) throws MageException {
        this.perform(playerId, playerId1 -> this.getGameSession(playerId1).informPersonal(message), false);
    }

    private void error(String message, Exception ex) {
        StringBuilder sb = new StringBuilder();
        sb.append(message);
        sb.append("\n");
        sb.append("\n");
        sb.append(ex);
        sb.append("\nServer version: ").append(Main.getVersion().toString());
        sb.append("\nStack trace:");
        sb.append("\n");
        for (StackTraceElement e : ex.getStackTrace()) {
            sb.append(e.toString()).append("\n");
        }
        String mes = sb.toString();
        for (Map.Entry<UUID, GameSessionPlayer> entry : this.getGameSessionsMap().entrySet()) {
            entry.getValue().gameError(mes);
        }
    }

    public synchronized GameView getGameView(UUID playerId) {
        return this.getGameSession(playerId).getGameView();
    }

    @Override
    public void endGameWithResult(String result) {
        try {
            this.endGame(result);
        }
        catch (MageException ex) {
            logger.fatal((Object)"Game Result error", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveGame() {
        block5: {
            boolean bl;
            FileOutputStream file = null;
            ObjectOutputStream output = null;
            BufferedOutputStream buffer = null;
            try {
                file = new FileOutputStream("saved/" + this.game.getId().toString() + ".game");
                buffer = new BufferedOutputStream(file);
                output = new ObjectOutputStream(new GZIPOutputStream(buffer));
                output.writeObject(this.game);
                output.writeObject(this.game.getGameStates());
                logger.debug((Object)("Saved game:" + this.game.getId()));
                bl = true;
                StreamUtils.closeQuietly((Closeable)file);
            }
            catch (IOException ex) {
                logger.fatal((Object)"Cannot save game.", (Throwable)ex);
                break block5;
            }
            finally {
                StreamUtils.closeQuietly(file);
                StreamUtils.closeQuietly(output);
                StreamUtils.closeQuietly(buffer);
            }
            StreamUtils.closeQuietly((AutoCloseable)output);
            StreamUtils.closeQuietly((Closeable)buffer);
            return bl;
        }
        return false;
    }

    private void perform(UUID playerId, Command command) {
        this.perform(playerId, command, true);
    }

    private void perform(UUID playerId, Command command, boolean informOthers) {
        Player player = this.game.getPlayer(playerId);
        if (player == null) {
            throw new IllegalArgumentException("Can't perform command for unknown player id: " + playerId);
        }
        Player realPlayerController = this.game.getPlayer(player.getTurnControlledBy());
        if (realPlayerController == null) {
            throw new IllegalArgumentException("Can't find real turn controller for player id: " + playerId);
        }
        if (this.gameSessions.containsKey(realPlayerController.getId())) {
            this.startResponseIdleTimeout(realPlayerController.getId());
            command.execute(realPlayerController.getId());
        }
        if (informOthers) {
            this.informOthers(realPlayerController.getId());
        }
    }

    private void sendMessage(UUID userId, Command command) {
        UUID playerId = (UUID)this.userPlayerMap.get(userId);
        Player player = this.game.getPlayer(playerId);
        if (player != null && player.isGameUnderControl()) {
            if (this.game.getPriorityPlayerId() == null || this.game.getPriorityPlayerId().equals(playerId)) {
                if (this.gameSessions.containsKey(playerId)) {
                    this.stopResponseIdleTimeout();
                    command.execute(playerId);
                }
            } else {
                for (UUID controlled : player.getPlayersUnderYourControl()) {
                    Player controlledPlayer = this.game.getPlayer(controlled);
                    if (!this.gameSessions.containsKey(controlled) && !controlledPlayer.isComputer() || !this.game.getPriorityPlayerId().equals(controlled)) continue;
                    this.stopResponseIdleTimeout();
                    command.execute(controlled);
                }
            }
        }
    }

    private void startResponseIdleTimeout(UUID playerId) {
        if (!this.useResponseIdleTimeout) {
            return;
        }
        this.stopResponseIdleTimeout();
        this.responseIdleTimeoutPlayerId = playerId;
        this.responseIdleTimeoutFuture = this.responseIdleTimeoutExecutor.schedule(() -> this.onResponseIdleTimeout(playerId), this.getResponseIdleTimeoutSecs(), TimeUnit.SECONDS);
    }

    private long getResponseIdleTimeoutSecs() {
        return Main.isTestMode() ? 3600L : (long)this.managerFactory.configSettings().getMaxSecondsIdle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopResponseIdleTimeout() {
        logger.debug((Object)"cancelTimeout");
        if (this.responseIdleTimeoutFuture != null) {
            ScheduledFuture<?> scheduledFuture = this.responseIdleTimeoutFuture;
            synchronized (scheduledFuture) {
                this.responseIdleTimeoutFuture.cancel(false);
                this.responseIdleTimeoutPlayerId = null;
            }
        }
    }

    private Map<UUID, GameSessionPlayer> getGameSessionsMap() {
        HashMap<UUID, GameSessionPlayer> newGameSessionsMap = new HashMap<UUID, GameSessionPlayer>();
        Lock r = this.gameSessionsLock.readLock();
        r.lock();
        try {
            newGameSessionsMap.putAll(this.gameSessions);
        }
        finally {
            r.unlock();
        }
        return newGameSessionsMap;
    }

    private List<GameSessionPlayer> getGameSessions() {
        ArrayList<GameSessionPlayer> newGameSessions = new ArrayList<GameSessionPlayer>();
        Lock r = this.gameSessionsLock.readLock();
        r.lock();
        try {
            newGameSessions.addAll(this.gameSessions.values());
        }
        finally {
            r.unlock();
        }
        return newGameSessions;
    }

    private List<GameSessionWatcher> getGameSessionWatchers() {
        ArrayList<GameSessionWatcher> newGameSessionWatchers = new ArrayList<GameSessionWatcher>();
        Lock r = this.gameSessionsLock.readLock();
        r.lock();
        try {
            newGameSessionWatchers.addAll(this.watchers.values());
        }
        finally {
            r.unlock();
        }
        return newGameSessionWatchers;
    }

    private void sendDirectPlayerUUID(UUID playerId, UUID data) {
        GameSessionPlayer session = this.getGameSession(playerId);
        if (session != null) {
            session.sendPlayerUUID(data);
            return;
        }
        Player player = this.game.getPlayer(playerId);
        if (player != null && player.isComputer()) {
            player.setResponseUUID(data);
        }
    }

    private void sendDirectPlayerString(UUID playerId, String data) {
        GameSessionPlayer session = this.getGameSession(playerId);
        if (session != null) {
            session.sendPlayerString(data);
            return;
        }
        Player player = this.game.getPlayer(playerId);
        if (player != null && player.isComputer()) {
            player.setResponseString(data);
        }
    }

    private void sendDirectPlayerManaType(UUID playerId, UUID manaTypePlayerId, ManaType manaType) {
        GameSessionPlayer session = this.getGameSession(playerId);
        if (session != null) {
            session.sendPlayerManaType(manaTypePlayerId, manaType);
            return;
        }
        Player player = this.game.getPlayer(playerId);
        if (player != null && player.isComputer()) {
            player.setResponseManaType(manaTypePlayerId, manaType);
        }
    }

    private void sendDirectPlayerBoolean(UUID playerId, Boolean data) {
        GameSessionPlayer session = this.getGameSession(playerId);
        if (session != null) {
            session.sendPlayerBoolean(data);
            return;
        }
        Player player = this.game.getPlayer(playerId);
        if (player != null && player.isComputer()) {
            player.setResponseBoolean(data);
        }
    }

    private void sendDirectPlayerInteger(UUID playerId, Integer data) {
        GameSessionPlayer session = this.getGameSession(playerId);
        if (session != null) {
            session.sendPlayerInteger(data);
            return;
        }
        Player player = this.game.getPlayer(playerId);
        if (player != null && player.isComputer()) {
            player.setResponseInteger(data);
        }
    }

    private GameSessionPlayer getGameSession(UUID playerId) {
        this.updatePriorityTimers();
        return (GameSessionPlayer)this.gameSessions.get(playerId);
    }

    public String getPlayerNameList() {
        StringBuilder sb = new StringBuilder(" [");
        for (UUID playerId : this.userPlayerMap.values()) {
            Player player = this.game.getPlayer(playerId);
            if (player != null) {
                sb.append(player.getName()).append("(Left=").append(player.hasLeft() ? "Y" : "N").append(") ");
                continue;
            }
            sb.append("player missing: ").append(playerId).append(' ');
        }
        return sb.append(']').toString();
    }

    public boolean isAllowedToWatch(UUID userId) {
        Optional<User> user = this.managerFactory.userManager().getUser(userId);
        if (user.isPresent()) {
            return !this.gameOptions.bannedUsers.contains(user.get().getName());
        }
        return false;
    }

    public String getGameStateDebugMessage() {
        Plane currentPlane;
        if (this.game == null) {
            return "";
        }
        GameState state = this.game.getState();
        if (state == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<br/>Game State:<br/><font size=-2>");
        sb.append(state);
        sb.append("<br>Active player is: ");
        sb.append(this.game.getPlayer(state.getActivePlayerId()).getName());
        sb.append("<br>isGameOver: ");
        sb.append(state.isGameOver());
        sb.append("<br>Current phase is: ");
        sb.append(state.getTurn().getPhase());
        sb.append("<br>getBattlefield: ");
        sb.append(state.getBattlefield());
        sb.append("<br>getChoosingPlayerId: ");
        if (state.getChoosingPlayerId() != null) {
            sb.append(this.game.getPlayer(state.getChoosingPlayerId()).getName());
        } else {
            sb.append("noone!");
        }
        sb.append("<br>getCombat: ");
        sb.append(state.getCombat());
        sb.append("<br>getCommand: ");
        sb.append(state.getCommand());
        sb.append("<br>getContinuousEffects: ");
        sb.append(state.getContinuousEffects());
        sb.append("<br>getCopiedCards: ");
        sb.append(state.getCopiedCards());
        sb.append("<br>getDelayed: ");
        sb.append(state.getDelayed());
        sb.append("<br>getDesignations: ");
        sb.append(state.getDesignations());
        sb.append("<br>getExile: ");
        sb.append(state.getExile());
        sb.append("<br>getMonarchId: ");
        sb.append(state.getMonarchId());
        sb.append("<br>getNextPermanentOrderNumber: ");
        sb.append(state.getNextPermanentOrderNumber());
        sb.append("<br>getPlayerByOrderId: ");
        if (state.getPlayerByOrderId() != null) {
            sb.append(this.game.getPlayer(state.getPlayerByOrderId()).getName());
        } else {
            sb.append("noone!");
        }
        sb.append("<br>getPlayerList: ");
        sb.append(state.getPlayerList());
        sb.append("<br>getPlayers: ");
        sb.append(state.getPlayers());
        sb.append("<br><font color=orange>Player with Priority is: ");
        if (state.getPriorityPlayerId() != null) {
            sb.append(this.game.getPlayer(state.getPriorityPlayerId()).getName());
        } else {
            sb.append("noone!");
        }
        sb.append("</font><br>getRevealed: ");
        sb.append(state.getRevealed());
        sb.append("<br>getSpecialActions: ");
        sb.append(state.getSpecialActions());
        sb.append("<br>getStack: ");
        sb.append(state.getStack());
        sb.append("<br>getStepNum: ");
        sb.append(state.getStepNum());
        sb.append("<br>getTurn: ");
        sb.append(state.getTurn());
        sb.append("<br>getExtraTurnId: ");
        sb.append(state.getExtraTurnId());
        sb.append("<br>getTurnMods: ");
        sb.append(state.getTurnMods());
        sb.append("<br>getTurnNum: ");
        sb.append(state.getTurnNum());
        sb.append("<br>Using plane chase?:" + state.isPlaneChase());
        if (state.isPlaneChase() && (currentPlane = state.getCurrentPlane()) != null) {
            sb.append("<br>Current plane:" + currentPlane.getName());
        }
        sb.append("<br>Future Timeout:");
        if (this.responseIdleTimeoutFuture != null) {
            sb.append("Cancelled?=");
            sb.append(this.responseIdleTimeoutFuture.isCancelled());
            sb.append(",,,Done?=");
            sb.append(this.responseIdleTimeoutFuture.isDone());
            sb.append(",,,GetDelay?=");
            sb.append((int)this.responseIdleTimeoutFuture.getDelay(TimeUnit.SECONDS));
        } else {
            sb.append("Not using future Timeout!");
        }
        sb.append("</font>");
        return sb.toString();
    }

    private String getName(Player player) {
        return player != null ? player.getName() : "none";
    }

    public String getPingsInfo() {
        ArrayList<String> usersInfo = new ArrayList<String>();
        for (Map.Entry entry : this.userPlayerMap.entrySet()) {
            Optional<User> user = this.managerFactory.userManager().getUser((UUID)entry.getKey());
            user.ifPresent(u -> usersInfo.add("* " + u.getName() + ": " + u.getPingInfo()));
        }
        Collections.sort(usersInfo);
        usersInfo.add(0, "Players ping:");
        ArrayList<String> watchersinfo = new ArrayList<String>();
        for (Map.Entry entry : this.watchers.entrySet()) {
            Optional<User> user = this.managerFactory.userManager().getUser(((GameSessionWatcher)entry.getValue()).userId);
            user.ifPresent(u -> watchersinfo.add("* " + u.getName() + ": " + u.getPingInfo()));
        }
        Collections.sort(watchersinfo);
        if (watchersinfo.size() > 0) {
            watchersinfo.add(0, "Watchers ping:");
        }
        usersInfo.addAll(watchersinfo);
        return String.join((CharSequence)"<br>", usersInfo);
    }

    private String asGood(String text) {
        return "<font color='green'><b>" + text + "</b></font>";
    }

    private String asBad(String text) {
        return "<font color='red'><b>" + text + "</b></font>";
    }

    private String asWarning(String text) {
        return "<font color='aqua'><b>" + text + "</b></font>";
    }

    public String attemptToFixGame(User user) {
        if (this.game == null) {
            return "";
        }
        GameState state = this.game.getState();
        if (state == null) {
            return "";
        }
        String playersInfo = this.game.getPlayerList().stream().map(this.game::getPlayer).filter(Objects::nonNull).map(p -> p.getName() + (p.isInGame() ? " (play)" : " (out)")).collect(Collectors.joining(", "));
        logger.warn((Object)("FIX command was called for game " + this.game.getId() + " by " + user.getName() + "; players: " + playersInfo + "; " + this.game));
        StringBuilder sb = new StringBuilder();
        sb.append("<font color='red'>FIX command called by ").append(user.getName()).append("</font>");
        sb.append("<font size='-2'>");
        sb.append("<br>Game ID: ").append(this.game.getId());
        if (this.game.getTurnPhaseType() == null) {
            sb.append("<br>Phase: not started").append(" Step: not started");
        } else {
            sb.append("<br>Phase: ").append(this.game.getTurnPhaseType().toString()).append(" Step: ").append(this.game.getTurnStepType().toString());
        }
        sb.append("<br>");
        sb.append(this.getPingsInfo());
        boolean fixedAlready = false;
        ArrayList<String> fixActions = new ArrayList<String>();
        fixedAlready = this.fixPlayer(this.game.getPlayer(state.getActivePlayerId()), state, "active", sb, fixActions, fixedAlready, false);
        fixedAlready = this.fixPlayer(this.game.getPlayer(state.getChoosingPlayerId()), state, "choosing", sb, fixActions, fixedAlready, false);
        fixedAlready = this.fixPlayer(this.game.getPlayer(state.getPriorityPlayerId()), state, "priority", sb, fixActions, fixedAlready, false);
        sb.append("<br>Fixing response idle timeout: ");
        if (this.responseIdleTimeoutFuture != null) {
            int delay = (int)this.responseIdleTimeoutFuture.getDelay(TimeUnit.SECONDS);
            if (delay < 25) {
                fixedAlready = this.fixPlayer(this.game.getPlayer(this.responseIdleTimeoutPlayerId), state, "response idle", sb, fixActions, fixedAlready, true);
            } else {
                sb.append(" (").append(this.asGood("OK")).append(String.format(", allow to idle %d of %d secs", delay, this.getResponseIdleTimeoutSecs()));
            }
        } else {
            sb.append(" (").append(this.asGood("OK")).append(", timeout is not using)");
        }
        if (fixActions.isEmpty()) {
            fixActions.add("none");
        }
        String appliedFixes = fixActions.stream().collect(Collectors.joining(", "));
        sb.append("<br>Applied fixes: ").append(appliedFixes);
        sb.append("</font>");
        sb.append("<br>");
        logger.warn((Object)("FIX command result: " + appliedFixes));
        return sb.toString();
    }

    private boolean fixPlayer(Player player, GameState state, String fixType, StringBuilder sb, List<String> fixActions, boolean fixedAlready, boolean forceToConcede) {
        sb.append("<br>Fixing ").append(fixType).append(" player: ").append(this.getName(player));
        if (player != null && (forceToConcede || !player.canRespond())) {
            fixActions.add(fixType + " fix");
            sb.append("<br><font color='red'>WARNING, ").append(fixType).append(" player can't respond.</font>");
            sb.append("<br>Try to concede...");
            player.concede(this.game);
            player.leave();
            sb.append(" (").append(this.asWarning("OK")).append(", concede done)");
            sb.append("<br>Try to skip step...");
            if (!fixedAlready) {
                Phase currentPhase = this.game.getPhase();
                if (currentPhase != null) {
                    currentPhase.getStep().skipStep(this.game, state.getActivePlayerId());
                    fixedAlready = true;
                    sb.append(" (").append(this.asWarning("OK")).append(", skip step done)");
                } else {
                    sb.append(" (").append(this.asBad("FAIL")).append(", step is null)");
                }
            } else {
                sb.append(" (OK, already skipped before)");
            }
        } else {
            sb.append(player != null ? " (" + this.asGood("OK") + ", can respond)" : " (" + this.asGood("OK") + ", no player)");
        }
        return fixedAlready;
    }

    public UUID getTableId() {
        return this.tableId;
    }

    @FunctionalInterface
    static interface Command {
        public void execute(UUID var1);
    }
}

