/*
 * Decompiled with CFR 0.152.
 */
package mage.server.game;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mage.game.match.Match;
import mage.game.match.MatchOptions;
import mage.game.match.MatchType;
import mage.view.GameTypeView;
import org.apache.log4j.Logger;

public enum GameFactory {
    instance;

    private static final Logger logger;
    private final Map<String, Class<Match>> games = new HashMap<String, Class<Match>>();
    private final Map<String, MatchType> gameTypes = new HashMap<String, MatchType>();
    private final List<GameTypeView> gameTypeViews = new ArrayList<GameTypeView>();

    public Match createMatch(String gameType, MatchOptions options) {
        Match match;
        try {
            Constructor<Match> con = this.games.get(gameType).getConstructor(MatchOptions.class);
            match = con.newInstance(options);
        }
        catch (Exception ex) {
            logger.fatal((Object)("Error creating match - " + gameType), (Throwable)ex);
            return null;
        }
        logger.debug((Object)("Game created: " + gameType));
        return match;
    }

    public List<GameTypeView> getGameTypes() {
        return this.gameTypeViews;
    }

    public void addGameType(String name, MatchType matchType, Class game) {
        if (matchType != null && game != null) {
            this.games.put(name, game);
            this.gameTypes.put(name, matchType);
            this.gameTypeViews.add(new GameTypeView(matchType));
        }
    }

    static {
        logger = Logger.getLogger(GameFactory.class);
    }
}

