/*
 * Decompiled with CFR 0.152.
 */
package mage.server.game;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import mage.constants.ManaType;
import mage.constants.PlayerAction;
import mage.game.Game;
import mage.game.GameOptions;
import mage.server.game.GameController;
import mage.server.managers.GameManager;
import mage.server.managers.ManagerFactory;
import mage.view.GameView;

public class GameManagerImpl
implements GameManager {
    private final ManagerFactory managerFactory;
    private final ConcurrentMap<UUID, GameController> gameControllers = new ConcurrentHashMap<UUID, GameController>();
    private final ReadWriteLock gameControllersLock = new ReentrantReadWriteLock();

    public GameManagerImpl(ManagerFactory managerFactory) {
        this.managerFactory = managerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UUID createGameSession(Game game, ConcurrentHashMap<UUID, UUID> userPlayerMap, UUID tableId, UUID choosingPlayerId, GameOptions gameOptions) {
        GameController gameController = new GameController(this.managerFactory, game, userPlayerMap, tableId, choosingPlayerId, gameOptions);
        Lock w = this.gameControllersLock.writeLock();
        w.lock();
        try {
            this.gameControllers.put(game.getId(), gameController);
        }
        finally {
            w.unlock();
        }
        return gameController.getSessionId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GameController getGameControllerSafe(UUID gameId) {
        Lock r = this.gameControllersLock.readLock();
        r.lock();
        try {
            GameController gameController = (GameController)this.gameControllers.get(gameId);
            return gameController;
        }
        finally {
            r.unlock();
        }
    }

    @Override
    public void joinGame(UUID gameId, UUID userId) {
        GameController gameController = this.getGameControllerSafe(gameId);
        if (gameController != null) {
            gameController.join(userId);
        }
    }

    @Override
    public Optional<UUID> getChatId(UUID gameId) {
        GameController gameController = this.getGameControllerSafe(gameId);
        if (gameController != null) {
            return Optional.of(gameController.getChatId());
        }
        return Optional.empty();
    }

    @Override
    public void sendPlayerUUID(UUID gameId, UUID userId, UUID data) {
        GameController gameController = this.getGameControllerSafe(gameId);
        if (gameController != null) {
            gameController.sendPlayerUUID(userId, data);
        }
    }

    @Override
    public void sendPlayerString(UUID gameId, UUID userId, String data) {
        GameController gameController = this.getGameControllerSafe(gameId);
        if (gameController != null) {
            gameController.sendPlayerString(userId, data);
        }
    }

    @Override
    public void sendPlayerManaType(UUID gameId, UUID playerId, UUID userId, ManaType data) {
        GameController gameController = this.getGameControllerSafe(gameId);
        if (gameController != null) {
            gameController.sendPlayerManaType(userId, playerId, data);
        }
    }

    @Override
    public void sendPlayerBoolean(UUID gameId, UUID userId, Boolean data) {
        GameController gameController = this.getGameControllerSafe(gameId);
        if (gameController != null) {
            gameController.sendPlayerBoolean(userId, data);
        }
    }

    @Override
    public void sendPlayerInteger(UUID gameId, UUID userId, Integer data) {
        GameController gameController = this.getGameControllerSafe(gameId);
        if (gameController != null) {
            gameController.sendPlayerInteger(userId, data);
        }
    }

    @Override
    public void quitMatch(UUID gameId, UUID userId) {
        GameController gameController = this.getGameControllerSafe(gameId);
        if (gameController != null) {
            gameController.quitMatch(userId);
        }
    }

    @Override
    public void sendPlayerAction(PlayerAction playerAction, UUID gameId, UUID userId, Object data) {
        GameController gameController = this.getGameControllerSafe(gameId);
        if (gameController != null) {
            gameController.sendPlayerAction(playerAction, userId, data);
        }
    }

    @Override
    public boolean watchGame(UUID gameId, UUID userId) {
        GameController gameController = this.getGameControllerSafe(gameId);
        if (gameController != null) {
            return gameController.watch(userId);
        }
        return false;
    }

    @Override
    public void stopWatching(UUID gameId, UUID userId) {
        GameController gameController = this.getGameControllerSafe(gameId);
        if (gameController != null) {
            gameController.stopWatching(userId);
        }
    }

    @Override
    public void cheatShow(UUID gameId, UUID userId, UUID playerId) {
        GameController gameController = this.getGameControllerSafe(gameId);
        if (gameController != null) {
            gameController.cheatShow(playerId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeGame(UUID gameId) {
        GameController gameController = this.getGameControllerSafe(gameId);
        if (gameController != null) {
            gameController.cleanUp();
            Lock w = this.gameControllersLock.writeLock();
            w.lock();
            try {
                this.gameControllers.remove(gameId);
            }
            finally {
                w.unlock();
            }
        }
    }

    @Override
    public boolean saveGame(UUID gameId) {
        GameController gameController = this.getGameControllerSafe(gameId);
        if (gameController != null) {
            return gameController.saveGame();
        }
        return false;
    }

    @Override
    public GameView getGameView(UUID gameId, UUID playerId) {
        GameController gameController = this.getGameControllerSafe(gameId);
        if (gameController != null) {
            return gameController.getGameView(playerId);
        }
        return null;
    }

    @Override
    public int getNumberActiveGames() {
        return this.getGameController().size();
    }

    @Override
    public Map<UUID, GameController> getGameController() {
        HashMap<UUID, GameController> newControllers = new HashMap<UUID, GameController>();
        Lock r = this.gameControllersLock.readLock();
        r.lock();
        try {
            newControllers.putAll(this.gameControllers);
        }
        finally {
            r.unlock();
        }
        return newControllers;
    }
}

