/*
 * Decompiled with CFR 0.152.
 */
package mage.server.game;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import mage.choices.Choice;
import mage.constants.ManaType;
import mage.constants.PlayerAction;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.Table;
import mage.interfaces.callback.ClientCallback;
import mage.interfaces.callback.ClientCallbackMethod;
import mage.players.Player;
import mage.server.User;
import mage.server.game.GameSessionWatcher;
import mage.server.managers.ManagerFactory;
import mage.server.managers.UserManager;
import mage.util.MultiAmountMessage;
import mage.view.AbilityPickerView;
import mage.view.CardsView;
import mage.view.GameClientMessage;
import mage.view.GameView;
import mage.view.SimpleCardsView;
import mage.view.UserRequestMessage;
import org.apache.log4j.Logger;

public class GameSessionPlayer
extends GameSessionWatcher {
    private static final Logger logger = Logger.getLogger(GameSessionPlayer.class);
    private final UserManager userManager;
    private final UUID playerId;
    private final ExecutorService callExecutor;

    public GameSessionPlayer(ManagerFactory managerFactory, Game game, UUID userId, UUID playerId) {
        super(managerFactory.userManager(), userId, game, true);
        this.userManager = managerFactory.userManager();
        this.callExecutor = managerFactory.threadExecutor().getCallExecutor();
        this.playerId = playerId;
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
    }

    public void ask(String question, Map<String, Serializable> options) {
        if (!this.killed) {
            this.userManager.getUser(this.userId).ifPresent(user -> user.fireCallback(new ClientCallback(ClientCallbackMethod.GAME_ASK, this.game.getId(), (Object)new GameClientMessage(this.getGameView(), options, question))));
        }
    }

    public void target(String question, CardsView cardView, Set<UUID> targets, boolean required, Map<String, Serializable> options) {
        if (!this.killed) {
            this.userManager.getUser(this.userId).ifPresent(user -> user.fireCallback(new ClientCallback(ClientCallbackMethod.GAME_TARGET, this.game.getId(), (Object)new GameClientMessage(this.getGameView(), options, question, cardView, targets, required))));
        }
    }

    public void select(String message, Map<String, Serializable> options) {
        if (!this.killed) {
            this.userManager.getUser(this.userId).ifPresent(user -> user.fireCallback(new ClientCallback(ClientCallbackMethod.GAME_SELECT, this.game.getId(), (Object)new GameClientMessage(this.getGameView(), options, message))));
        }
    }

    public void chooseAbility(AbilityPickerView abilities) {
        if (!this.killed) {
            this.userManager.getUser(this.userId).ifPresent(user -> user.fireCallback(new ClientCallback(ClientCallbackMethod.GAME_CHOOSE_ABILITY, this.game.getId(), (Object)abilities)));
        }
    }

    public void choosePile(String message, CardsView pile1, CardsView pile2) {
        if (!this.killed) {
            this.userManager.getUser(this.userId).ifPresent(user -> user.fireCallback(new ClientCallback(ClientCallbackMethod.GAME_CHOOSE_PILE, this.game.getId(), (Object)new GameClientMessage(this.getGameView(), null, message, pile1, pile2))));
        }
    }

    public void chooseChoice(Choice choice) {
        if (!this.killed) {
            this.userManager.getUser(this.userId).ifPresent(user -> user.fireCallback(new ClientCallback(ClientCallbackMethod.GAME_CHOOSE_CHOICE, this.game.getId(), (Object)new GameClientMessage(this.getGameView(), null, choice))));
        }
    }

    public void playMana(String message, Map<String, Serializable> options) {
        if (!this.killed) {
            this.userManager.getUser(this.userId).ifPresent(user -> user.fireCallback(new ClientCallback(ClientCallbackMethod.GAME_PLAY_MANA, this.game.getId(), (Object)new GameClientMessage(this.getGameView(), options, message))));
        }
    }

    public void playXMana(String message) {
        if (!this.killed) {
            this.userManager.getUser(this.userId).ifPresent(user -> user.fireCallback(new ClientCallback(ClientCallbackMethod.GAME_PLAY_XMANA, this.game.getId(), (Object)new GameClientMessage(this.getGameView(), null, message))));
        }
    }

    public void getAmount(String message, int min, int max) {
        if (!this.killed) {
            this.userManager.getUser(this.userId).ifPresent(user -> user.fireCallback(new ClientCallback(ClientCallbackMethod.GAME_GET_AMOUNT, this.game.getId(), (Object)new GameClientMessage(this.getGameView(), null, message, min, max))));
        }
    }

    public void getMultiAmount(List<MultiAmountMessage> messages, int min, int max, Map<String, Serializable> options) {
        if (!this.killed) {
            this.userManager.getUser(this.userId).ifPresent(user -> user.fireCallback(new ClientCallback(ClientCallbackMethod.GAME_GET_MULTI_AMOUNT, this.game.getId(), (Object)new GameClientMessage(this.getGameView(), options, messages, min, max))));
        }
    }

    public void endGameInfo(Table table) {
        if (!this.killed) {
            this.userManager.getUser(this.userId).ifPresent(user -> user.fireCallback(new ClientCallback(ClientCallbackMethod.END_GAME_INFO, this.game.getId(), (Object)this.getGameEndView(this.playerId, table))));
        }
    }

    public void requestPermissionToRollbackTurn(UUID requestingUserId, int numberTurns) {
        if (!this.killed) {
            Optional<User> requestingUser = this.userManager.getUser(requestingUserId);
            Optional<User> requestedUser = this.userManager.getUser(this.userId);
            if (requestedUser.isPresent() && requestingUser.isPresent()) {
                String message;
                switch (numberTurns) {
                    case 0: {
                        message = "Allow rollback to the start of the current turn?";
                        break;
                    }
                    case 1: {
                        message = "Allow rollback to the start of the previous turn?";
                        break;
                    }
                    default: {
                        message = "Allow to rollback " + numberTurns + " turns?";
                    }
                }
                UserRequestMessage userRequestMessage = new UserRequestMessage("Request by " + requestedUser.get().getName(), message);
                userRequestMessage.setRelatedUser(requestingUserId, requestingUser.get().getName());
                userRequestMessage.setGameId(this.game.getId());
                userRequestMessage.setButton1("Accept", PlayerAction.ADD_PERMISSION_TO_ROLLBACK_TURN);
                userRequestMessage.setButton2("Deny", PlayerAction.DENY_PERMISSION_TO_ROLLBACK_TURN);
                requestedUser.get().fireCallback(new ClientCallback(ClientCallbackMethod.USER_REQUEST_DIALOG, this.game.getId(), (Object)userRequestMessage));
            }
        }
    }

    public void requestPermissionToSeeHandCards(UUID watcherId) {
        if (!this.killed) {
            Optional<User> watcher = this.userManager.getUser(watcherId);
            Optional<User> user = this.userManager.getUser(this.userId);
            if (user.isPresent() && watcher.isPresent()) {
                UserRequestMessage userRequestMessage = new UserRequestMessage("User request", "Allow user <b>" + watcher.get().getName() + "</b> for this match to see your hand cards?<br>(You can revoke this every time using related popup menu item of your battlefield.)");
                userRequestMessage.setRelatedUser(watcherId, watcher.get().getName());
                userRequestMessage.setGameId(this.game.getId());
                userRequestMessage.setButton1("Accept", PlayerAction.ADD_PERMISSION_TO_SEE_HAND_CARDS);
                userRequestMessage.setButton2("Reject", null);
                user.get().fireCallback(new ClientCallback(ClientCallbackMethod.USER_REQUEST_DIALOG, this.game.getId(), (Object)userRequestMessage));
            }
        }
    }

    public void sendPlayerUUID(UUID data) {
        this.game.getPlayer(this.playerId).setResponseUUID(data);
    }

    public void sendPlayerString(String data) {
        this.game.getPlayer(this.playerId).setResponseString(data);
    }

    public void sendPlayerManaType(UUID manaTypePlayerId, ManaType manaType) {
        this.game.getPlayer(this.playerId).setResponseManaType(manaTypePlayerId, manaType);
    }

    public void sendPlayerBoolean(Boolean data) {
        this.game.getPlayer(this.playerId).setResponseBoolean(data);
    }

    public void sendPlayerInteger(Integer data) {
        this.game.getPlayer(this.playerId).setResponseInteger(data);
    }

    @Override
    public GameView getGameView() {
        return GameSessionPlayer.prepareGameView(this.game, this.playerId, this.userId);
    }

    public static GameView prepareGameView(Game game, UUID playerId, UUID userId) {
        Player controllingPlayer;
        Game sourceGame = (Game)game.copy();
        GameView gameView = new GameView(sourceGame.getState(), sourceGame, playerId, null);
        Player player = sourceGame.getPlayer(playerId);
        Player priorityPlayer = sourceGame.getPlayer(sourceGame.getPriorityPlayerId());
        Player player2 = controllingPlayer = priorityPlayer == null ? null : sourceGame.getPlayer(priorityPlayer.getTurnControlledBy());
        if (controllingPlayer != null && player == controllingPlayer) {
            gameView.setCanPlayObjects(priorityPlayer.getPlayableObjects(sourceGame, Zone.ALL));
        }
        GameSessionPlayer.processControlledPlayers(sourceGame, player, gameView);
        GameSessionPlayer.processWatchedHands(sourceGame, userId, gameView);
        return gameView;
    }

    private static void processControlledPlayers(Game game, Player player, GameView gameView) {
        if (player == null) {
            return;
        }
        gameView.getOpponentHands().clear();
        if (!player.getPlayersUnderYourControl().isEmpty()) {
            for (UUID controlledPlayerId : player.getPlayersUnderYourControl()) {
                Player opponent = game.getPlayer(controlledPlayerId);
                gameView.getOpponentHands().put(opponent.getName(), new SimpleCardsView(opponent.getHand().getCards(game), true));
            }
        }
    }

    public void removeGame() {
        this.userManager.getUser(this.userId).ifPresent(user -> user.removeGame(this.playerId));
    }

    public UUID getGameId() {
        return this.game.getId();
    }

    public void quitGame() {
        if (this.game != null) {
            Player player = this.game.getPlayer(this.playerId);
            if (player != null && player.isInGame()) {
                this.callExecutor.execute(() -> {
                    try {
                        if (this.game.getStartTime() == null) {
                            player.leave();
                        } else {
                            player.quit(this.game);
                        }
                    }
                    catch (Exception ex) {
                        if (ex != null) {
                            logger.fatal((Object)("Game session game quit exception " + (ex.getMessage() == null ? "null" : ex.getMessage())));
                            logger.debug((Object)("- gameId:" + this.game.getId() + "  playerId: " + this.playerId));
                            if (ex.getCause() != null) {
                                logger.debug((Object)("- Cause: " + (ex.getCause().getMessage() == null ? "null" : ex.getCause().getMessage())), (Throwable)ex);
                            } else {
                                logger.debug((Object)("- ex: " + ex), (Throwable)ex);
                            }
                        }
                        logger.fatal((Object)("Game session game quit exception - null  gameId:" + this.game.getId() + "  playerId: " + this.playerId));
                    }
                });
            }
        } else {
            logger.error((Object)("game object missing   playerId: " + (this.playerId == null ? "[null]" : this.playerId)));
        }
    }
}

