/*
 * Decompiled with CFR 0.152.
 */
package mage.server.game;

import java.util.Optional;
import java.util.UUID;
import mage.game.Game;
import mage.game.Table;
import mage.interfaces.callback.ClientCallback;
import mage.interfaces.callback.ClientCallbackMethod;
import mage.players.Player;
import mage.server.User;
import mage.server.managers.UserManager;
import mage.view.GameClientMessage;
import mage.view.GameEndView;
import mage.view.GameView;
import mage.view.SimpleCardsView;
import org.apache.log4j.Logger;

public class GameSessionWatcher {
    protected static final Logger logger = Logger.getLogger(GameSessionWatcher.class);
    private final UserManager userManager;
    protected final UUID userId;
    protected final Game game;
    protected boolean killed = false;
    protected final boolean isPlayer;

    public GameSessionWatcher(UserManager userManager, UUID userId, Game game, boolean isPlayer) {
        this.userManager = userManager;
        this.userId = userId;
        this.game = game;
        this.isPlayer = isPlayer;
    }

    public boolean init() {
        Optional<User> user;
        if (!this.killed && (user = this.userManager.getUser(this.userId)).isPresent()) {
            user.get().fireCallback(new ClientCallback(ClientCallbackMethod.GAME_INIT, this.game.getId(), (Object)this.getGameView()));
            return true;
        }
        return false;
    }

    public void update() {
        if (!this.killed) {
            this.userManager.getUser(this.userId).ifPresent(user -> user.fireCallback(new ClientCallback(ClientCallbackMethod.GAME_UPDATE, this.game.getId(), (Object)this.getGameView())));
        }
    }

    public void inform(String message) {
        if (!this.killed) {
            this.userManager.getUser(this.userId).ifPresent(user -> user.fireCallback(new ClientCallback(ClientCallbackMethod.GAME_UPDATE_AND_INFORM, this.game.getId(), (Object)new GameClientMessage(this.getGameView(), null, message))));
        }
    }

    public void informPersonal(String message) {
        if (!this.killed) {
            this.userManager.getUser(this.userId).ifPresent(user -> user.fireCallback(new ClientCallback(ClientCallbackMethod.GAME_INFORM_PERSONAL, this.game.getId(), (Object)new GameClientMessage(this.getGameView(), null, message))));
        }
    }

    public void gameOver(String message) {
        if (!this.killed) {
            this.userManager.getUser(this.userId).ifPresent(user -> {
                user.removeGameWatchInfo(this.game.getId());
                user.fireCallback(new ClientCallback(ClientCallbackMethod.GAME_OVER, this.game.getId(), (Object)new GameClientMessage(this.getGameView(), null, message)));
            });
        }
    }

    public void cleanUp() {
    }

    public void gameError(String message) {
        if (!this.killed) {
            this.userManager.getUser(this.userId).ifPresent(user -> user.fireCallback(new ClientCallback(ClientCallbackMethod.GAME_ERROR, this.game.getId(), (Object)message)));
        }
    }

    public void setKilled() {
        this.killed = true;
    }

    public GameView getGameView() {
        Game sourceGame = (Game)this.game.copy();
        GameView gameView = new GameView(sourceGame.getState(), sourceGame, null, this.userId);
        GameSessionWatcher.processWatchedHands(sourceGame, this.userId, gameView);
        return gameView;
    }

    protected static void processWatchedHands(Game game, UUID userId, GameView gameView) {
        gameView.getWatchedHands().clear();
        for (Player player : game.getPlayers().values()) {
            if (!player.hasUserPermissionToSeeHand(userId)) continue;
            gameView.getWatchedHands().put(player.getName(), new SimpleCardsView(player.getHand().getCards(game), true));
        }
    }

    public GameEndView getGameEndView(UUID playerId, Table table) {
        return new GameEndView(this.game.getState(), this.game, playerId, table);
    }

    public boolean isPlayer() {
        return this.isPlayer;
    }
}

