/*
 * Decompiled with CFR 0.152.
 */
package mage.server.game;

import java.util.UUID;
import java.util.concurrent.Callable;
import mage.MageException;
import mage.game.Game;
import mage.server.game.GameCallback;
import org.apache.log4j.Logger;

public class GameWorker
implements Callable<Boolean> {
    private static final Logger LOGGER = Logger.getLogger(GameWorker.class);
    private final GameCallback gameController;
    private final Game game;
    private final UUID choosingPlayerId;

    public GameWorker(Game game, UUID choosingPlayerId, GameCallback gameController) {
        this.game = game;
        this.choosingPlayerId = choosingPlayerId;
        this.gameController = gameController;
    }

    @Override
    public Boolean call() {
        try {
            Thread.currentThread().setName("GAME " + this.game.getId());
            this.game.start(this.choosingPlayerId);
            this.game.fireUpdatePlayersEvent();
            this.gameController.endGameWithResult(this.game.getWinner());
            this.game.cleanUp();
        }
        catch (MageException e) {
            LOGGER.fatal((Object)("GameWorker mage error [" + this.game.getId() + " - " + this.game + "]: " + e), (Throwable)e);
        }
        catch (Throwable e) {
            LOGGER.fatal((Object)("GameWorker system error [" + this.game.getId() + " - " + this.game + "]: " + e), e);
        }
        return null;
    }
}

