/*
 * Decompiled with CFR 0.152.
 */
package mage.server.game;

import java.lang.reflect.Constructor;
import java.util.EnumMap;
import java.util.Optional;
import java.util.Set;
import mage.constants.RangeOfInfluence;
import mage.players.Player;
import mage.players.PlayerType;
import org.apache.log4j.Logger;

public enum PlayerFactory {
    instance;

    private static final Logger logger;
    private final EnumMap<PlayerType, Class> playerTypes = new EnumMap(PlayerType.class);

    public Optional<Player> createPlayer(PlayerType playerType, String name, RangeOfInfluence range, int skill) {
        try {
            Class playerTypeClass = this.playerTypes.get((Object)playerType);
            if (playerTypeClass != null) {
                Constructor con = playerTypeClass.getConstructor(String.class, RangeOfInfluence.class, Integer.TYPE);
                Player player = (Player)con.newInstance(new Object[]{name, range, skill});
                logger.trace((Object)("Player created: " + name + " - " + player.getId()));
                return Optional.of(player);
            }
            logger.fatal((Object)("Unknown player type: " + (Object)((Object)playerType)));
        }
        catch (Exception ex) {
            logger.fatal((Object)"PlayerFactory error ", (Throwable)ex);
        }
        return Optional.empty();
    }

    public Set<PlayerType> getPlayerTypes() {
        return this.playerTypes.keySet();
    }

    public void addPlayerType(String name, Class playerType) {
        PlayerType type = PlayerType.getByDescription(name);
        if (playerType != null) {
            this.playerTypes.put(type, playerType);
        }
    }

    static {
        logger = Logger.getLogger(PlayerFactory.class);
    }
}

